/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.bot;

import eem.frame.bot.InfoBot;
import eem.frame.bot.botStatPoint;
import eem.frame.core.CoreBot;
import eem.frame.event.botListener;
import eem.frame.gameInfo.gameInfo;
import eem.frame.misc.logger;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.LinkedList;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class botsManager {
    public CoreBot myBot;
    public gameInfo _gameinfo;
    public static HashMap<String, InfoBot> liveBots = new HashMap();
    public static HashMap<String, InfoBot> deadBots = new HashMap();
    protected double distAtWhichHitProbabilityDrops = 200.0;
    public LinkedList<botListener> botListeners = new LinkedList();

    public botsManager(CoreBot coreBot, gameInfo gameInfo2) {
        this.myBot = coreBot;
        this._gameinfo = gameInfo2;
        if (deadBots.size() >= 1) {
            for (InfoBot infoBot : deadBots.values()) {
                String string = infoBot.getName();
                liveBots.put(string, infoBot);
            }
        }
        deadBots.clear();
    }

    public InfoBot getBotByName(String string) {
        InfoBot infoBot = null;
        infoBot = liveBots.get(string);
        if (null != infoBot) {
            return infoBot;
        }
        infoBot = deadBots.get(string);
        if (null != infoBot) {
            return infoBot;
        }
        logger.error("Bots manager cannot find bot: " + string);
        return infoBot;
    }

    public void initTic(long l) {
        this.updateMasterBotStatus(this.myBot);
        for (InfoBot infoBot : liveBots.values()) {
            infoBot.initTic(l);
        }
    }

    public LinkedList<InfoBot> listOfKnownBots() {
        LinkedList<InfoBot> linkedList = new LinkedList<InfoBot>();
        linkedList.addAll(this.listOfAliveBots());
        linkedList.addAll(this.listOfDeadBots());
        return linkedList;
    }

    public LinkedList<InfoBot> listOfAliveBots() {
        LinkedList<InfoBot> linkedList = new LinkedList<InfoBot>();
        for (InfoBot infoBot : liveBots.values()) {
            linkedList.add(infoBot);
        }
        return linkedList;
    }

    public LinkedList<InfoBot> listOfDeadBots() {
        LinkedList<InfoBot> linkedList = new LinkedList<InfoBot>();
        for (InfoBot infoBot : deadBots.values()) {
            linkedList.add(infoBot);
        }
        return linkedList;
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        String string = robotDeathEvent.getName();
        logger.noise("botManager: bot " + string + " is dead");
        InfoBot infoBot = liveBots.get(string);
        deadBots.put(string, infoBot);
        liveBots.remove(string);
        this.callListenersOnRobotDeath(infoBot);
    }

    public void add(InfoBot infoBot) {
        liveBots.put(infoBot.getName(), infoBot);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
    }

    public void updateMasterBotStatus(CoreBot coreBot) {
        String string = coreBot.getName();
        InfoBot infoBot = liveBots.get(string);
        if (infoBot == null) {
            infoBot = new InfoBot(string);
        }
        infoBot.update(new botStatPoint(coreBot));
        liveBots.put(string, infoBot);
        this._gameinfo.specialOnScannedRobot(infoBot);
        this.callListenersOnScannedRobot(infoBot);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        String string = scannedRobotEvent.getName();
        InfoBot infoBot = deadBots.get(string);
        if (infoBot != null) {
            logger.noise("bot manager: ressurecting " + string);
            logger.noise("old ref " + deadBots.get(string));
            logger.noise("new ref " + infoBot);
            liveBots.put(string, infoBot);
            deadBots.remove(string);
        }
        if ((infoBot = liveBots.get(string)) == null) {
            infoBot = new InfoBot(string);
        }
        infoBot.update(new botStatPoint(this.myBot, scannedRobotEvent));
        this._gameinfo.specialOnScannedRobot(infoBot);
        liveBots.put(string, infoBot);
        this.callListenersOnScannedRobot(infoBot);
    }

    public void addBotListener(botListener botListener2) {
        this.botListeners.add(botListener2);
    }

    public void callListenersOnScannedRobot(InfoBot infoBot) {
        for (botListener botListener2 : this.botListeners) {
            botListener2.onScannedRobot(infoBot);
        }
    }

    public void callListenersOnRobotDeath(InfoBot infoBot) {
        for (botListener botListener2 : this.botListeners) {
            botListener2.onRobotDeath(infoBot);
        }
    }

    public String toString() {
        String string = "";
        string = string + "botManager stats\n";
        string = string + " liveBots known = " + liveBots.size() + "\n";
        for (InfoBot infoBot : liveBots.values()) {
            string = string + "  bot: " + infoBot.getName() + "\n";
        }
        string = string + " deadBots known = " + deadBots.size() + "\n";
        for (InfoBot infoBot : deadBots.values()) {
            string = string + "  bot: " + infoBot.getName() + "\n";
        }
        return string;
    }

    public void onPaint(Graphics2D graphics2D) {
        for (InfoBot infoBot : liveBots.values()) {
            infoBot.onPaint(graphics2D);
        }
    }
}

