/*
 * Decompiled with CFR 0.152.
 */
package florent;

import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;

public class DynamicDistancing {
    private static double[] benefit = new double[26];
    private static double[] penalty = new double[26];
    private double energy = 100.0;
    private double distance;
    private int distanceIndex;
    private static DynamicDistancing theInstance;

    public static DynamicDistancing getInstance() {
        if (theInstance == null) {
            theInstance = new DynamicDistancing();
        }
        return theInstance;
    }

    private DynamicDistancing() {
    }

    public void init() {
        this.energy = 100.0;
    }

    public boolean isTooClose() {
        return this.distance < (double)(this.findDistanceBracket() - 120);
    }

    public boolean isTooFar() {
        return this.distance > (double)this.findDistanceBracket();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double deltaEnergy = this.energy - e.getEnergy();
        this.distance = e.getDistance();
        this.distanceIndex = (int)this.distance / 50;
        if (deltaEnergy > 0.0 && deltaEnergy <= 3.0) {
            int n = this.distanceIndex;
            benefit[n] = benefit[n] + deltaEnergy;
        }
    }

    public void onGunFire(double power) {
        int n = this.distanceIndex;
        penalty[n] = penalty[n] + power;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double power = e.getPower();
        this.energy += power * 3.0;
        int n = this.distanceIndex;
        penalty[n] = penalty[n] + Math.max(power * 7.0, power * 9.0 - 2.0);
    }

    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = Math.max(4.0 * power, 6.0 * power - 2.0);
        this.energy -= damage;
        int n = this.distanceIndex;
        benefit[n] = benefit[n] + (damage + power * 3.0);
    }

    public int findDistanceBracket() {
        int bestindex = 4;
        int i = 4;
        do {
            if (!(this.findBenefit(i) > this.findBenefit(bestindex))) continue;
            bestindex = i;
        } while (++i <= 14);
        return bestindex * 50 + 85;
    }

    private double findBenefit(int index) {
        return (benefit[index] - penalty[index]) / (benefit[index] + penalty[index]);
    }
}

