/*
 * Decompiled with CFR 0.152.
 */
package rdt199;

import java.awt.Color;
import rdt199.Manager;
import rdt199.movement.GravityDodgeMode;
import rdt199.movement.GravityMeleeMode;
import rdt199.movement.MovementManager;
import rdt199.radar.FindTargetMode;
import rdt199.radar.TrackTargetMode;
import rdt199.radar.WideMode;
import rdt199.tracking.BulletTracker;
import rdt199.tracking.NearestMode;
import rdt199.tracking.VirtualBullet;
import rdt199.util.BotFuncs;
import rdt199.util.RobotLog;
import rdt199.util.RobotLogger;
import rdt199.util.SelfLog;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Warlord
extends AdvancedRobot {
    protected BotFuncs m_StaticFuncs;
    protected Manager m_RadarManager;
    protected Manager m_TargetManager;
    protected MovementManager m_MoveManager;
    protected RobotLogger m_DualLogger;
    protected RobotLogger m_MeleeLogger;

    public void run() {
        this.m_StaticFuncs = new BotFuncs(this);
        SelfLog MyLog = new SelfLog();
        BotFuncs.setSelfLog(MyLog);
        this.m_DualLogger = new RobotLogger("dual_");
        this.m_MeleeLogger = new RobotLogger("melee_");
        this.initRadarManager();
        this.initTargetManager();
        this.initMoveManager();
        this.setColors(Color.white, Color.white, Color.orange);
        this.setTurnRadarRight(360.0);
        while (true) {
            BotFuncs.setHitTarget(false, 0.0);
            MyLog.update();
            if (this.getOthers() < 2) {
                BotFuncs.setLogger(this.m_DualLogger);
            } else {
                BotFuncs.setLogger(this.m_MeleeLogger);
            }
            this.m_TargetManager.update();
            this.m_RadarManager.update();
            this.m_MoveManager.update();
            RobotLog Target = BotFuncs.getTarget();
            if (Target != null) {
                Target.getGunManager().update();
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        BotFuncs.m_RobotLogger.update(event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        BotFuncs.m_RobotLogger.killBot(event);
        System.out.println("Bot Died .... " + event.getName());
    }

    private void initRadarManager() {
        this.m_RadarManager = new Manager(3);
        this.m_RadarManager.addMode(new TrackTargetMode());
        this.m_RadarManager.addMode(new WideMode());
        this.m_RadarManager.addMode(new FindTargetMode());
    }

    private void initTargetManager() {
        this.m_TargetManager = new Manager(1);
        this.m_TargetManager.addMode(new NearestMode());
    }

    private void initMoveManager() {
        this.m_MoveManager = new MovementManager(2);
        this.m_MoveManager.addMode(new GravityMeleeMode(this.m_MoveManager));
        this.m_MoveManager.addMode(new GravityDodgeMode(this.m_MoveManager));
    }

    private void close() {
        this.m_TargetManager.close();
        this.m_RadarManager.close();
        this.m_MoveManager.close();
        BotFuncs.m_RobotLogger.close();
    }

    public void onDeath(DeathEvent event) {
        this.close();
    }

    public void onWin(WinEvent event) {
        this.close();
    }

    public void onBulletHit(BulletHitEvent event) {
        Bullet HitBullet = event.getBullet();
        double dDamage = HitBullet.getPower() * 4.0;
        if (HitBullet.getPower() > 1.0) {
            dDamage += 2.0 * (HitBullet.getPower() - 1.0);
        }
        BotFuncs.setHitTarget(true, dDamage);
    }

    public void onCustomEvent(CustomEvent event) {
        Condition condition = event.getCondition();
        if (condition instanceof BulletTracker) {
            BulletTracker bt = (BulletTracker)condition;
            bt.getMode().setActualHit(bt.hitTarget());
        } else if (condition instanceof VirtualBullet) {
            VirtualBullet Bullet2 = (VirtualBullet)condition;
            Bullet2.getMode().setVirtualHit(Bullet2);
        }
    }

    public void onSkippedTurnEvent(SkippedTurnEvent event) {
        System.out.println("SKIPPING TURN");
    }
}

