/*
 * Decompiled with CFR 0.152.
 */
package rdt199.radar;

import rdt199.Mode;
import rdt199.util.BotFuncs;
import rdt199.util.Location;

public abstract class RadarMode
extends Mode {
    boolean m_bWaggle;

    public RadarMode() {
        BotFuncs.m_AdvancedRobot.setAdjustRadarForGunTurn(true);
        this.m_bWaggle = false;
    }

    public void track(Location loc) {
        Location Loc = new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY());
        double dTheta = BotFuncs.getAbsBearing(loc, Loc);
        dTheta = Math.toDegrees(dTheta);
        dTheta = this.m_bWaggle ? (dTheta -= 45.0) : (dTheta += 45.0);
        this.m_bWaggle = !this.m_bWaggle;
        this.setAbsoluteRadar(dTheta);
    }

    private void setAbsoluteRadar(double angle) {
        double dAngle = BotFuncs.normaliseAbsDegrees(angle);
        if (dAngle < BotFuncs.m_AdvancedRobot.getRadarHeading()) {
            if (BotFuncs.m_AdvancedRobot.getRadarHeading() - dAngle > 180.0) {
                BotFuncs.m_AdvancedRobot.setTurnRadarRight(360.0 - (BotFuncs.m_AdvancedRobot.getRadarHeading() - dAngle));
            } else {
                BotFuncs.m_AdvancedRobot.setTurnRadarLeft(BotFuncs.m_AdvancedRobot.getRadarHeading() - dAngle);
            }
        } else if (dAngle - BotFuncs.m_AdvancedRobot.getRadarHeading() > 180.0) {
            BotFuncs.m_AdvancedRobot.setTurnRadarLeft(360.0 - (dAngle - BotFuncs.m_AdvancedRobot.getRadarHeading()));
        } else {
            BotFuncs.m_AdvancedRobot.setTurnRadarRight(dAngle - BotFuncs.m_AdvancedRobot.getRadarHeading());
        }
    }
}

