/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import morbid.FieldAwareObject;
import morbid.IBulletObject;
import morbid.IEnemyBulletManager;
import morbid.IObject;
import morbid.IRobotController;
import morbid.Utils;

final class EnemyBulletManager
extends FieldAwareObject
implements IEnemyBulletManager {
    private final Map m_bullets;
    private final double m_wallMargin;
    private final double[] m_interpolate = new double[2];
    private IBulletObject.IBullet[] m_bullets_cache;
    private static final boolean DO_HEADING_BASED_DEACTIVATION = true;
    private static final String ID_PREFIX = "EB.";

    public void update() {
        Iterator i = this.m_bullets.values().iterator();
        while (i.hasNext()) {
            EnemyBullet bullet = (EnemyBullet)i.next();
            boolean active = bullet.isActive();
            Utils.interpolate(this.m_interpolate, bullet.getX(), bullet.getY(), bullet.getHeadingRadians(), bullet.getVelocity(), 1.0);
            bullet.setXY(this.m_interpolate);
            double headingToRobot = Utils.relativeHeading(bullet.getX(), bullet.getY(), this.m_robot.getX(), this.m_robot.getY());
            boolean bl = active = Math.abs(Utils.deltaPhi(headingToRobot, bullet.getHeadingRadians())) < 1.6022122533307945;
            if (active) {
                boolean bl2 = active = !Utils.onTheBoundary(bullet.getXY(), this.m_wallMargin, this.m_battleFieldWidth, this.m_battleFieldHeight);
            }
            if (active) continue;
            bullet.setActive(false);
            i.remove();
            this.m_bullets_cache = null;
        }
    }

    public IBulletObject.IBullet addBullet(String sourceID, String targetID, long startTime, double x, double y, double heading, double power, Object collateral) {
        String newID = Utils.getGID(ID_PREFIX);
        EnemyBullet newBullet = new EnemyBullet(newID, sourceID, targetID, x, y, heading, power, collateral);
        if (startTime < this.m_robot.getTime()) {
            Utils.interpolate(this.m_interpolate, newBullet.getX(), newBullet.getY(), newBullet.getHeadingRadians(), newBullet.getVelocity(), 1.0 * (double)(this.m_robot.getTime() - startTime));
            newBullet.setXY(this.m_interpolate);
        }
        this.m_bullets.put(newID, newBullet);
        this.m_bullets_cache = null;
        return newBullet;
    }

    public IBulletObject.IBullet removeBullet(String ID) {
        IBulletObject.IBullet result = (IBulletObject.IBullet)this.m_bullets.remove(ID);
        if (result != null) {
            this.m_bullets_cache = null;
        }
        return result;
    }

    public boolean isActive(String ID) {
        IBulletObject.IBullet result = (IBulletObject.IBullet)this.m_bullets.get(ID);
        return result != null && result.isActive();
    }

    public IBulletObject.IBullet[] getActiveBullets() {
        if (this.m_bullets_cache == null) {
            this.m_bullets_cache = this.m_bullets.values().toArray(new IBulletObject.IBullet[this.m_bullets.size()]);
        }
        return this.m_bullets_cache;
    }

    EnemyBulletManager(IRobotController controller) {
        super(controller);
        this.m_bullets = new HashMap();
        this.m_wallMargin = 0.5 * Math.min(this.m_robot.getWidth(), this.m_robot.getHeight());
    }

    private static final class EnemyBullet
    extends IObject.NamedMovingObject
    implements IBulletObject.IBullet {
        private final String m_sourceID;
        private final String m_targetID;
        private final double m_power;
        private final Object m_collateral;
        private boolean m_active;

        public final boolean isActive() {
            return this.m_active;
        }

        public String getSourceID() {
            return this.m_sourceID;
        }

        public String getTargetID() {
            return this.m_targetID;
        }

        public String getVictimID() {
            return null;
        }

        public final double getPower() {
            return this.m_power;
        }

        public Object getCollateral() {
            return this.m_collateral;
        }

        public String toString() {
            StringBuffer s = new StringBuffer(0);
            s.append('{');
            s.append(this.getID());
            s.append(": ");
            s.append(Utils.printDouble(this.getX()));
            s.append('/');
            s.append(Utils.printDouble(this.getY()));
            s.append(", H ");
            s.append(Utils.printPhi(this.getHeadingRadians()));
            s.append(", V ");
            s.append(Utils.printDouble(this.getVelocity()));
            s.append(", P ");
            s.append(Utils.printDouble(this.getPower()));
            s.append('}');
            return s.toString();
        }

        private EnemyBullet(String ID, String sourceID, String targetID, double x, double y, double heading, double power, Object collateral) {
            super(ID, x, y, heading, Utils.bulletPowerToVelocity(power));
            this.m_power = power;
            this.m_sourceID = sourceID;
            this.m_targetID = targetID;
            this.m_active = true;
            this.m_collateral = collateral;
        }

        private final void setActive(boolean active) {
            this.m_active = active;
        }
    }
}

