/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.bots;

import de.simpleworks.robocode.botUtil.AngleCalc;
import de.simpleworks.robocode.botUtil.Coordinate;
import de.simpleworks.robocode.botUtil.CsCalc;
import de.simpleworks.robocode.debug.Debug;
import de.simpleworks.robocode.stats.BulletQuene;
import de.simpleworks.robocode.stats.EnemyStats;
import de.simpleworks.robocode.strategy.FireStrategyManager;
import de.simpleworks.robocode.strategy.MovementStrategyManager;
import de.simpleworks.robocode.strategy.fire.FireStrategy;
import de.simpleworks.robocode.strategy.movement.MovementStrategy;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotStatus;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;

public class swiBot
extends AdvancedRobot {
    private boolean FDebugActive = false;
    private FireStrategyManager FFSMan = new FireStrategyManager();
    private MovementStrategyManager FMSMan = new MovementStrategyManager();
    private BulletQuene FBulletQ = new BulletQuene();
    private EnemyStats FEnemyStats = new EnemyStats();
    private RobotStatus FCurrentStatus = null;

    public RobotStatus getCurrentStatus() {
        return this.FCurrentStatus;
    }

    protected EnemyStats getEnemyStats() {
        return this.FEnemyStats;
    }

    protected BulletQuene getBulletQ() {
        return this.FBulletQ;
    }

    protected boolean getDebugIsActive() {
        return this.FDebugActive;
    }

    protected void setDebugActive(boolean _active) {
        this.FDebugActive = _active;
    }

    protected boolean getTurnDirLeft(double _angleDiff) {
        return _angleDiff > 0.0 && _angleDiff < 180.0 || _angleDiff < -180.0;
    }

    protected boolean getTurnDirRight(double _angleDiff) {
        return !this.getTurnDirLeft(_angleDiff) && this.getMustTurn(_angleDiff);
    }

    protected boolean getMustTurn(double _angleDiff) {
        return _angleDiff != 0.0;
    }

    protected double getAngleToTurn(double _itemHead, double _targetAngle) {
        double aDiff = AngleCalc.getBearing(_itemHead, _targetAngle);
        return aDiff;
    }

    public void turnGunTo(double _angle) {
        double bearing = this.getAngleToTurn(this.getGunHeading(), _angle);
        this.turnGunRight(bearing);
    }

    public void turnRadarTo(double _angle) {
        double bearing = this.getAngleToTurn(this.getRadarHeading(), _angle);
        this.turnRadarRight(bearing);
    }

    public void turnTo(double _angle) {
        double bearing = this.getAngleToTurn(this.getHeading(), _angle);
        this.turnRight(bearing);
    }

    public void turnNorth() {
        this.turnTo(0.0);
    }

    public void turnEast() {
        this.turnTo(90.0);
    }

    public void turnSouth() {
        this.turnTo(180.0);
    }

    public void turnWest() {
        this.turnTo(270.0);
    }

    public void syncGunToRadar() {
        this.turnGunTo(this.getRadarHeading());
    }

    public void syncGunToHead() {
        this.turnGunLeft(this.getHeading());
    }

    public void syncAllToHead() {
        this.turnRadarTo(this.getHeading());
        this.syncGunToRadar();
    }

    public void moveTo(double _x, double _y) {
        if (_x > this.getX()) {
            this.turnEast();
            this.ahead(_x - this.getX());
        } else {
            this.turnWest();
            this.ahead(this.getX() - _x);
        }
        if (_y > this.getY()) {
            this.turnNorth();
            this.ahead(_y - this.getY());
        } else {
            this.turnSouth();
            this.ahead(this.getY() - _y);
        }
    }

    public void moveToDirect(double _x, double _y) {
        this.moveToDirect(new Coordinate(_x, _y));
    }

    public void moveToDirect(double _x, double _y, double _scanAny) {
        this.moveToDirect(new Coordinate(_x, _y), _scanAny);
    }

    public void moveToDirect(Coordinate _targetPos) {
        Coordinate sp = new Coordinate(this.getX(), this.getY());
        double targetAngle = CsCalc.calcTargetAngle(sp, _targetPos);
        double targetDistance = CsCalc.calcDistance(sp, _targetPos);
        this.turnTo(targetAngle);
        this.ahead(targetDistance);
    }

    public void moveToDirect(Coordinate _targetPos, double _scanAny) {
        Coordinate sp = new Coordinate(this.getX(), this.getY());
        double targetAngle = CsCalc.calcTargetAngle(sp, _targetPos);
        double targetDistance = CsCalc.calcDistance(sp, _targetPos);
        this.turnTo(targetAngle);
        this.ahead(targetDistance, _scanAny);
    }

    public void ahead(double _dist, double _scanAny) {
        double restDist = _dist;
        while (restDist > 0.0) {
            if (_scanAny > restDist) {
                this.ahead(restDist);
                this.scanComplete();
                restDist = 0.0;
                continue;
            }
            this.ahead(_scanAny);
            this.scanComplete();
            restDist -= _scanAny;
        }
    }

    public void scanComplete() {
        if (this.canFire()) {
            this.turnRadarLeft(360.0);
        }
    }

    public void moveToSqares(double _x, double _y, double _scanRate) {
        if (_x > this.getX()) {
            this.turnEast();
            this.ahead(_x - this.getX(), _scanRate);
        } else {
            this.turnWest();
            this.ahead(this.getX() - _x, _scanRate);
        }
        if (_y > this.getY()) {
            this.turnNorth();
            this.ahead(_y - this.getY(), _scanRate);
        } else {
            this.turnSouth();
            this.ahead(this.getY() - _y, _scanRate);
        }
    }

    public void moveToCenter() {
        this.moveTo(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
    }

    protected boolean canFire() {
        return this.getGunHeat() == 0.0;
    }

    public void fire(double _power, double _targetAngle, String _targetName) {
        this.turnGunTo(_targetAngle);
        Debug.print(this.getDebugIsActive(), "Aim Bot: head=" + Double.toString(this.getHeading()) + ", targetAngle=" + Double.toString(_targetAngle) + ", gunHead=" + Double.toString(this.getGunHeading()));
        this.FBulletQ.put(_targetName, this.getFS(_targetName).getStrategyName(), this.fireBullet(_power));
    }

    protected FireStrategy getFS(String _tName) {
        return this.FFSMan.getStrategy(_tName);
    }

    protected MovementStrategy getMS() {
        return this.FMSMan.getStrategy(this.getCurrentStatus().getOthers());
    }

    protected void setup() {
        this.setDebugActive(true);
        this.setBodyColor(Color.BLACK);
        this.setGunColor(Color.orange);
        this.setRadarColor(Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.FFSMan.registerStats(this.FEnemyStats);
    }

    public void run() {
        this.setup();
        while (true) {
            this.getMS().execDefaultPattern(this);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.FEnemyStats.putStat(e);
        FireStrategy thisStrat = this.getFS(e.getName());
        thisStrat.update(e, this.FCurrentStatus, 0.0, this.getBattleFieldHeight(), this.getBattleFieldWidth());
        double power = thisStrat.getPower();
        if (thisStrat.willFire()) {
            this.fire(power, thisStrat.getGunAngle(), e.getName());
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.getMS().execHitByBulletPattern(this);
    }

    public void onStatus(StatusEvent e) {
        this.FCurrentStatus = e.getStatus();
    }

    public void onHitWall(HitWallEvent event) {
        this.getMS().execHitWallPattern(this, event);
    }

    public void onHitRobot(HitRobotEvent event) {
        this.getMS().execHitBotPattern(this, event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        Debug.print(this.FDebugActive, "Bullet Missed Target");
        this.getBulletQ().release(event.getBullet(), this.getEnemyStats());
    }

    public void onBulletHit(BulletHitEvent event) {
        this.getBulletQ().release(event.getBullet(), this.getEnemyStats());
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.getBulletQ().discard(event.getBullet());
    }

    public void onBattleEnded(BattleEndedEvent event) {
        this.getBulletQ().flushInactive(this.getEnemyStats());
    }
}

