package ags.polylunar.communication;

import java.io.Serializable;
import java.util.Map;

import ags.polylunar.robotdata.*;
import ags.polylunar.robotdata.log.LogSituation;
import ags.util.points.*;

public class ScanData implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String name;
    public final AbsolutePoint location;
    public final RelativePoint velocity;
    public final double energy;
    public final Map<String, LogSituation> situations;
    public final double angularVelocity;
    
    public ScanData(HostileBot enemy) {
        name = enemy.getName();
        location = enemy.getNewLocation();
        velocity = enemy.getNewVelocity();
        energy = enemy.getNewEnergy();
        situations = enemy.getNewSituations();
        angularVelocity = enemy.getNewAngularVelocity();
    }
}
