package bvh.tyr;

import robocode.*;
/**
 * Doel - deze class bevat zoveel mogelijk informatie over het doel:
 *
 * Deze class wordt gebruikt om gescande tegenstanders op te slaan en
 * om het huidig doel vast te leggen.
 */
class Doel implements Constanten {

   static Tyr  mijnBot;

   public String naam = null;
   public double x, y;
   public double v, vGem, vRot;
   public double e, e_o, deltaE;
   public double bewegingsrichting;    // x-pos, y-pos, snelheid, energie, richting
   public double afstand, richting;    // afstand en hoek tov. mijn botje
   public long   scanTijd, scanTijd_o; // tijd waarop doel is gescanned
   public double x_o, y_o, x_n, y_n;   // historie van doel...en schatting toekomst
   public double v_o, vRot_o;
   public double bewegingsrichting_o;
   public double afstand_o, richting_o;
   public int    aantalAfgevuurdeKogels;
   public int    aantalIngeslagenKogels;

   public Doel( Tyr bot ) { // constructor
      mijnBot  = bot;
      resetInfo();
   }

   public void resetInfo(){
      naam                  = null;  // naam uitvegen zodat doel wordt gereset
      scanTijd              = 10000; // groot zodat Loki niet steeds opnieuw wordt gereset
      afstand= afstand_o    = 0;     // afstand en energie nul ivm bewegingsstrategie
      v = v_o               = 0;     // snelheid
      vGem                  = 0;     // gemiddelde snelheid = 0
      e = e_o = deltaE      = 0;     // energie
      richting = richting_o = 0;
      bewegingsrichting     = 0;
      bewegingsrichting_o   = 0;
      vRot                  = 0;
      aantalAfgevuurdeKogels= 0;
      aantalIngeslagenKogels= 0;
   }

   public void setInfo(ScannedRobotEvent evt, AdvancedRobot bot) {
         naam                = evt.getName();

// opslaan voorgaande scan-waarden:
         scanTijd_o          = scanTijd;
         e_o                 = e;
         v_o                 = v;
         afstand_o           = afstand;
         richting_o          = richting;
         bewegingsrichting_o = bewegingsrichting;
         x_o                 = x;
         y_o                 = y;
// vastleggen nieuwe scan-waarden:
         scanTijd            = bot.getTime();
         e                   = evt.getEnergy();
         v                   = evt.getVelocity();
         afstand             = evt.getDistance();
         richting            = bot.getHeadingRadians() + evt.getBearingRadians();
         bewegingsrichting   = evt.getHeadingRadians();
         x                   = setX( bot.getX() );
         y                   = setY( bot.getY() );
// bepalen van de afgeleide waarden:
         deltaE              = e_o - e;
         vGem                = 0.8 * vGem + 0.2 * v; // middelen over voorafgaande snelheden
         if (scanTijd_o != 0)
            vRot      = (bewegingsrichting - bewegingsrichting_o) / (double)(scanTijd - scanTijd_o);
         else
            vRot             = 0;

// code om te bepalen of doel schiet en om gegevens m.b.t. kogel vast te leggen:
         if ( (deltaE  > 0)&&(deltaE <= 3) ) { // schiet doel?
            aantalAfgevuurdeKogels += 1;
// dan waarden van het doel doorgeven aan de kogel (let op: nieuwe doel.richting omdat kogel tussen
// deze de vorige scan is afgevuurd. Check geeft aan dat huidige richting beter werkt):
            Kogel   inkomendeKogel    = new Kogel();
            inkomendeKogel.setKogel(deltaE, x, y, afstand, richting, scanTijd, (String)(naam+aantalAfgevuurdeKogels));
            mijnBot.tank.kogels.put((String)(naam+aantalAfgevuurdeKogels), inkomendeKogel);

if (mijnBot.debugMode > 1) mijnBot.out.println(naam+" schiet ("+aantalAfgevuurdeKogels+"): afstand="+afstand+", vInkomendeKogel="+inkomendeKogel.v);
         }
   }

/**
* Set-methoden om de teller met het aantal ingeslagen kogels op te hogen en te resetten.
*/
   public void setAantalIngeslagenKogels(HitByBulletEvent e) {
	   if (e.getName() == naam) aantalIngeslagenKogels++;
	}
   public void resetAantalIngeslagenKogels() {aantalIngeslagenKogels = 0;}
   public int  getAantalIngeslagenKogels() {return aantalIngeslagenKogels;}

/**
* Set-methoden om de x,y-waarden van het doel hun waarde te geven o.b.v. afstand
* en richting t.o.v. de eigen bot
*/
   public double setX(double xB) {return  (xB + afstand * Math.sin(richting) );}
   public double setY(double yB) {return  (yB + afstand * Math.cos(richting) );}

/**
* Methoden schatten de x,y-waarden van het doel op tijd t o.b.v. de aanname
* dat het doel een lineaire beweging uitvoert.
*/
   public double xt(long t) {return  (x + Math.sin(bewegingsrichting) * v * t);}
   public double yt(long t) {return  (y + Math.cos(bewegingsrichting) * v * t);}

/**
* Methoden schatten de x,y-waarden van het doel op tijd t o.b.v. de aanname
* dat het doel een lineaire beweging uitvoert met zijn gemiddelde snelheid.
*/
   public double xtMean(long t) {return  (x + Math.sin(bewegingsrichting) * vGem * t);}
   public double ytMean(long t) {return  (y + Math.cos(bewegingsrichting) * vGem * t);}

 } // einde class Doel
/**********************************************************************
** EINDE DOEL
**********************************************************************/
