/*
 * Created on 14/11/2003
 * 
 * $Id: Radar.java,v 1.1.1.1.8.2 2004/10/24 19:00:18 lolo Exp $
 */
package mnt.utils;

//import mnt.utils.*;
import robocode.*;

/**
 * Controla el movimiento del radar.
 * 
 * @author Lolo
 */
public class Radar {
    private final static short DERECHA = 1;

    //	private final static short IZQUIERDA = -1;

    private short dirRadar = DERECHA;

    private Enemigo objetivo;

    private AdvancedRobot miRobot;

    public Radar(AdvancedRobot miRobot) {
        this.miRobot = miRobot;
        //System.out.println("Constructor " + getClass());
    }

    public void setObjetivo(Enemigo e) {
        objetivo = e;
        //System.out.println("Actualizando objetivo " + miRobot.getTime());
    }

    /**
     * @return Returns the objetivo.
     */
    public Enemigo getObjetivo() {
        return objetivo;
    }
    public void hacerGiro() {
        if (objetivo != null) {
            double bearing = RoboMath.getBearing(miRobot.getX(),
                                                 miRobot.getY(), miRobot
                                                         .getRadarHeading(),
                                                 objetivo.getX(), objetivo
                                                         .getY());
            miRobot.setTurnRadarRight(bearing + dirRadar * 8);
            dirRadar = (short) (dirRadar * -1); //invierte la direcci�n del
                                                // radar
            //System.out.println("Girando radar " + bearing + " pos: "
            //      + objetivo.getX() + ", " + objetivo.getY());
        }
    }
}