package ar.horizon;

import java.awt.geom.*;

import ar.horizon.util.*;
import robocode.*;

/**
 * A pluggable robot component that receives the same kind of events as the
 * robot itself.
 * 
 * @author Aaron Rotenberg
 */
public abstract class Component {
	/**
	 * Convenience object that represents the boundaries of the battlefield,
	 * minus the radius of a robot. Used for wall smoothing, precise prediction,
	 * etc.
	 */
	protected static Rectangle2D.Double fieldRectangle;
	/**
	 * This reference to the robot is used to obtain status info, execute
	 * commands, and output debugging data.
	 */
	protected Horizon robot = null;
	// Recordings and logs that are auto-updated by the robot.
	protected RobotRecording myRecording;
	protected RobotLog myLog;
	protected RobotRecording enemyRecording;
	protected boolean roundEnded = false;

	public Component() {
	}

	void initialize(final Horizon robot, final RobotLog myLog) {
		this.robot = robot;
		this.myLog = myLog;
	}

	public void run() {
	}

	public void onTickBegin() {
	}

	public void onTickEnd() {
	}

	public void onScannedRobot(
			@SuppressWarnings("unused") final ScannedRobotEvent e) {
	}

	public void onBulletHit(@SuppressWarnings("unused") final BulletHitEvent e) {
	}

	public void onHitByBullet(
			@SuppressWarnings("unused") final HitByBulletEvent e) {
	}

	public void onBulletHitBullet(
			@SuppressWarnings("unused") final BulletHitBulletEvent e) {
	}

	public void onRoundEnd() {
	}
}
