package axeBots.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;


import axeBots.AxeBot;
import axeBots.AxeException;
import axeBots.SilverSurfer;
import axeBots.silversurfer.AxeTarget;
import axeBots.silversurfer.AxeVector;
import axeBots.util.RoboMath;

//import java.awt.Point;
import java.awt.geom.*;

/**
 * PatternSample - 11/06/2004
 * 
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * 
 * datailed on: http://robowiki.net/?RWPCL (Basically it means you must keep the
 * code public if you base any code on it.) Not basically, i think it means that
 * the knowledge should not be retained, but shared. We must all remember that
 * the veins of the Knowledge must flow. Quoting(or some) PEZs comment about
 * OpenSouce: "At least is a good Karma".
 */
public class PatternSample implements Comparable {

	// The static reference. Used by the instances to rate themselves in the
	// compareTo()
	private static PatternSample REFERENCE = new PatternSample();
	// samples wideness
	public static int GROUPS[] =
	{1, 2, 3, 4, 5,6,7, 10, 15, 20, 30, 40};
	

	// the samples
	private AxeVector samples[] = new AxeVector[12];
	private double distanceMe = 0;
	private double headToMe = 0;
	private double myAttackAngle = 0;
	private double distanceCorner = 0;
	private double distanceWall = 0;
	private double itsRate = 0;
	private int round = 0;
	private int pos = 0;
	private long timeSinceDeacc;

	private double originalAngle = 0;
	private int bucket;
	private double aged;
	private double rated;
	
	
	private static final int MAX_HITS=10;
	private int hits;
	private boolean hit=false;
	
	private static int sampCount=0;
	public static final int AGING_LIFE = 100;
	private int thisCount=0; 

	public PatternSample() {
		super();
		for (int i = 0; i < samples.length; i++) {
			samples[i] = new AxeVector();
		}
	}

	public PatternSample(AxeVector samps[], int pos, double distMe,
			double headToMe, long timeSinceAcc, long timeSinceDeacc,
			long timeSinceFire, double myAttackAngle) throws AxeException {
		super();
		this.setTimeSinceDeacc(timeSinceDeacc);
		this.setHeadToMe(headToMe);
		this.setMyAttackAngle(myAttackAngle);
		AxeTarget him = AxeBot.getIt().getMyTarget();
		sampCount++;
		thisCount=sampCount; 
		this.pos = pos;
		
		if (samps.length == GROUPS.length) {
			distanceMe = distMe;
			Point2D.Double p = samps[0].getEndPoint();
			distanceCorner = RoboMath.distToCorner(p);
			this.setWallsDistance(him); 
			samples = samps;
			this.normalize();
			// ROTATE THE FIRST VECTOR TO NORTH (0 DEGREES)
			// ROTATE THE REST BY THE AMOUNT ROTATED BY THE FIRST.
		} else {
			throw new AxeException("PatternSample: wrong samples array size:"
					+ GROUPS.length);
		}
		
	}

    public PatternSample(ArrayList interpol, int clicks, double distMe,
			double headToMe, long timeSinceAcc, long timeSinceDeacc,
			long timeSinceFire, double myAttackAngle) throws AxeException {
		super();
		this.setHeadToMe(headToMe);
		this.setMyAttackAngle(myAttackAngle);
		int pos = interpol.size() - 1;
		distanceMe = distMe;
		int depth = clicks - 1;
		if ((interpol == null) || interpol.isEmpty() || (depth < 1)) {
			throw new AxeException("PatternSample: source empty or null.");
		}
		this.setTimeSinceDeacc(timeSinceDeacc);
		
		AxeTarget him = AxeBot.getIt().getMyTarget();
		
		this.pos = pos;
		Point2D.Double p0 = ((AxeVector) interpol.get(pos)).getEndPoint();
		
		

		distanceCorner = RoboMath.distToCorner(p0);
		this.setWallsDistance(him);

		for (int i = 0; i < samples.length; i++) {
			int tail = pos - PatternSample.GROUPS[i];

			if ((tail < 0) || (GROUPS[i] > depth)) {
				break;
			} else {
				Point2D.Double pf = ((AxeVector) interpol.get(tail))
						.getEndPoint();
				samples[i] = new AxeVector(p0, pf);
			}
		}

		this.normalize();

	}

	

	public double rate() {

		double rate = 0;
		AxeVector refs[] = PatternSample.REFERENCE.getSamples();

		for (int i = 0; i < GROUPS.length; i++) {
			rate += (refs[i] == null) ? 0 : (refs[i].getDiffModule(samples[i]))
					/ (double) GROUPS[i];//(Math.pow( GROUPS[i],1.25));

		}


		double hdiff = Math.abs(REFERENCE.headToMe) - Math.abs(this.headToMe);

		double ddiff = REFERENCE.distanceMe - this.distanceMe;
		double wdiff = REFERENCE.distanceWall - this.distanceWall;
		double cdiff = REFERENCE.distanceCorner - this.distanceCorner;
		double tsdeaccdiff = REFERENCE.timeSinceDeacc - this.timeSinceDeacc;

		//PEZ dicovered this "bug"(?)...
		//I was using rate += (rate * ... without using a bonus
		//variable.
		//The rate calculation was not what i expected,
		//not sure if it would make any difference, but 
		//at least gives me a different rate...
		//Dunno however if it will make any dif, or even
		//break it, but im curious...
		//So, all Blame or Shame to PEZ...
		double penalty = 0;
		penalty += (rate * (tsdeaccdiff * tsdeaccdiff / 200.00));
		penalty += (rate * (ddiff * ddiff / 20000.00));
		penalty += (rate * (cdiff * cdiff / 20000.00));
		penalty += (rate * (hdiff * hdiff / 500.00));
		penalty += (rate * (wdiff * wdiff / 20000.00));
		rate += penalty;
		
//		//premio pros ultimos acertos
//		if(hits>0){
//			rate /= 1D+(1D - Math.pow((double)hits/(double)MAX_HITS,2 ));
//			hits--;
//		}
		
//		//premio pros acertados
//		rate /= (hit)?2D:1D;
//		
		//FAST LEARNING AGING
		int difAge = sampCount - thisCount;
		
		rate /= 1D + ((difAge < AGING_LIFE)?3D*(1D-Math.pow(((double)difAge/(double)AGING_LIFE),0.5)):0);
		
		itsRate = rate;
		return rate;
	}
	
	
	
	/**
	 * Sets the static reference vector. By being static all the instances will
	 * be able to use it to rate themselves.
	 * 
	 * @param sample
	 *            The 6 reference vectors
	 */
	public static void setOrderParams(PatternSample sample, int maxRound,
			int maxClick) {
		//        MAX_SAMPLE_AGE= (maxRound * 1000000) + maxClick;
		REFERENCE = sample;
		//		ROTATE THE FIRST VECTOR TO NORTH (0 DEGREES)
		// ROTATE THE REST BY THE AMOUNT ROTATED BY THE FIRST.
	}

	public static int getMaxWideness() {
		return GROUPS[GROUPS.length - 1];
	}

	public int compareTo(Object obj) {
		//        int ret= 0;
		// DO THE 6 VECTORS COMPARISSON WITH THE
		// 6 STATIC REFERENCE VECTORS.
		// RETURN THE RATING (LOWER, BETTER!)
		PatternSample him = (PatternSample) obj;
		//long myAge= this.getAge();
		//long hisAge= him.getAge();

		double myRate = this.getItsRate();
		double hisRate = him.getItsRate();
		return (myRate < hisRate) ? -1 : (myRate > hisRate) ? 1 : (this
				.getPos() > him.getPos()) ? -1 : 1;

	}

	
	public AxeVector[] getSamples() {
		return samples;
	}

	
	public void setSamples(AxeVector[] vectors) {
		samples = vectors;
	}


	private void normalize() {

		originalAngle = samples[0].getRelativeTheta();
		for (int i = 0; i < GROUPS.length; i++) {
			if (samples[i] != null) {
				samples[i].addTheta(-originalAngle);
			}
		}
	}
	
	public double getOriginalAngle() {
		return originalAngle;
	}

	
	public int getPos() {
		return pos;
	}

	
	public double getDistanceMe() {
		return distanceMe;
	}

	
	public void setDistanceMe(double d) {
		distanceMe = d;
	}

	
	public double getItsRate() {
		return itsRate;
	}

	
	public String toString() {
		return "PatternSample pos:" + this.getPos() + " rate:"
				+ this.getItsRate() + " rated:" + this.getRated() + " aged:"
				+ this.getAged();
	}


	public int getRound() {
		return round;
	}


	public void setRound(int i) {
		round = i;
	}


	public char getHeadToMe() {
		return (char) headToMe;
	}

	public char getMyAttackAngle() {
		return (char) myAttackAngle;
	}


	public void setHeadToMe(double d) {
		headToMe = Math.abs(RoboMath.normalRelativeAngle(d));
	}

	public void setMyAttackAngle(double d) {
		myAttackAngle = Math.abs(RoboMath.normalRelativeAngle(d));
	}


	
	public long getTimeSinceDeacc() {
		return timeSinceDeacc;
	}
	public void setTimeSinceDeacc(long timeSinceDeacc) {
		this.timeSinceDeacc = (timeSinceDeacc > BotData.MAX_TIME)
				? BotData.MAX_TIME
				: timeSinceDeacc;
	}
	

	public void setBucket(int i) {
		bucket = i;

	}

	public int getBucket() {
		return bucket;

	}

	public void setAged(double d) {
		aged = d;

	}
	public double getAged() {
		return aged;

	}

	public void setRated(double d) {
		rated = d;

	}
	public double getRated() {
		return rated;

	}
	
	public void setWallsDistance(AxeTarget him) {
	    Point2D.Double pos = him.pos();
		double heading = RoboMath.normalRelativeAngle(  Math.toDegrees( him.getHeading()));
		distanceWall=RoboMath.distanceToWall(pos,heading,him.getVelocity() );
	}

	public void hit() {
		hits=MAX_HITS ;
		hit=true;
	}

	public int getHits() {
		return hits;
	}
	
	public static void incSampCont(int sampCont) {
		PatternSample.sampCount += sampCont;
	}
}