
package axeBots.pilot.navigator;

import java.awt.geom.*;

import axeBots.AxeBot;
import axeBots.silversurfer.AxeVector;
import axeBots.util.RoboMath;


/** 
 * BotSimulator - 17/06/2004
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on:
 * http://robowiki.net/?RWPCL
 * (Basically it means you must keep the code public if you base any code on
 * it.)
 * Not basically, i think it means that the knowledge should not be 
 * retained, but shared. We must all remember that the veins of the Knowledge 
 * must flow. Quoting(or some) PEZs comment about OpenSouce: "At least is a 
 * good Karma".
 */
public class BotSimulator {

	private AxeVector path = new AxeVector();
	private Point2D.Double pos = new Point2D.Double();
	private double velDir = +1;
	private double systemMaxTurnRate=10D;
	private double systemMaxVelocity=8D;
	private boolean re=false;
	private AxeBot it = null;
	private double desloc;
//	private int 
	public BotSimulator() {
		super();
	}
	public BotSimulator(AxeBot bot) {
		it=bot;
		reset();
	}
	
	public void reset(){
		double heading =RoboMath.normalRelativeAngle( it.getHeading());
		double vel=(int)Math.round( it.getVelocity());
		desloc = 0;
		setRe(it.isRe());
		pos.setLocation(it.getX(),it.getY() );
		
		path.set(pos,heading,1);
		velDir=1;
		this.setVel ( vel);
	}
	private void setVel(double vel){
		vel=((int)vel==0)?0.1:vel;
		int newVelDir = (vel<0)?-1:1;
		
		path.setModule((newVelDir*velDir)*Math.abs(vel) );
		velDir = newVelDir;
	}
	
	private double getVel(){
		
		return velDir*Math.round( path.getModule());
	}
	private boolean isRe() {
		return re;
	}
	public void setRe(boolean re) {
		this.re = re;
	}
	public Point2D.Double walkBot( double desiredHeading){
		int dir = getReDir();
		double vel = getVel();
		
		this.updateHeading(desiredHeading,vel );
		
			//			desacelerando
			if ((dir * vel) < 0) {
				if (vel < 0) {
					vel += (vel < 0) ? +2 : -2;
					vel = (vel > 0) ? 0 : vel;
				} else {
					vel += (vel < 0) ? +2 : -2;
					vel = (vel < 0) ? 0 : vel;
				}
//				acumul -= Math.abs(vel);
			} else {
				if (Math.abs(vel) < 8) {
					vel += (dir < 0) ? -1 : 1;
				}
//				acumul += Math.abs(vel);
			}
			this.setVel (vel);
			double dif = Math.toRadians(  RoboMath.normalAbsoluteAngle (((getReDir()*velDir<0)?180:0)+path.getDiffTheta(desiredHeading )));
			desloc+=((Math.cos(dif )*(double)getVel()*getReDir())); 
			pos = path.getEndPoint();
			//transposiccao
			path.set(pos,path.getTheta(),path.getModule() );
//			System.out.println("dif:"+forma.format(Math.toDegrees(dif))+"("+forma.format(Math.cos(dif))+") "+this);
		return pos;
	}
	
	public Point2D.Double walkBot(){
		
		return walkBot( RoboMath.normalRelativeAngle (((getReDir()*velDir<0)?180:0)+path.getTheta( )));
		
	}
	
	
	
	private int getReDir(){
		return (re)?-1:1;
	}
	
	private void updateHeading(double to, double vel) {
		double dif = RoboMath.normalRelativeAngle (((getReDir()*velDir<0)?180:0)+path.getDiffTheta(to ));
		double turnRate = ((dif<0)?-1:1)*Math.min(Math.abs(dif), Math.min(systemMaxTurnRate,(.4 + .6 * (1 - (Math.abs(vel) / systemMaxVelocity))) * systemMaxTurnRate));
		path.addTheta(turnRate );		
	}
	
	public double getDesloc() {
		return desloc;
	}
	public String toString() {
		
		return it.getName()+" BotSimulator re:"+re+" dirVel:"+velDir+" desloc:"+desloc+" path:"+path ;
	}
}
