/*
 * Created on Nov 3, 2004
 *
 */
package davidalves.net.gun.segmentation;

import davidalves.net.util.RobotState;

/**
 * @author David Alves
 *
 */
public class OrbitalWallsSegmentation extends Segmentation{
	
	int segments;
	double maxAngle;
	double distanceFactor;
	
	public OrbitalWallsSegmentation(double distanceFactor, double maxAngle, int segments){
		this.segments = segments;
		this.maxAngle = maxAngle;
		this.distanceFactor = distanceFactor;
	}
	
	public int numSegments() {
		return segments;
	}
	
	public int getSegment(RobotState shooter, RobotState target, double bulletPower) {
		double orbitDirection = target.directionOrbitingAround(shooter);
		double initialAngle = shooter.absoluteAngleTo(target);
		double distance = shooter.distanceTo(target);
		int i = 1;
		while(i < segments){
			double projectionAngle = initialAngle + orbitDirection * i * maxAngle / segments;
			if(!shooter.project(projectionAngle, distance * distanceFactor).isOnDrivableField()) break;
			i++;
		}
		return i - 1;
	}
	
}
