/*
 * Created on Feb 29, 2004
 *
 */
package davidalves.net.util;

public class RobotState extends MotionState {
	
	
	//Scanned values
	public String name;
	public long time = -1; //So that deltas will be invalid for EnemyStates not created from scans
	public double energy;
	
	//Other values
	public boolean deltasValid; //True as long as we don't miss a scan
	public double deltaHeading;
	public double previousVelocity;
	public double distanceTraveled;
	public double timeAtThisSpeed;
	public double acceleration;
	
	public double lastNonZeroVelocity = 1;
	public double headingAtLastMove;
	
	public double directionOrbitingAround(Point p){
		double sine = Math.sin(heading - p.absoluteAngleTo(this));
		double orbitVelocity = velocity * sine;
		
		if(orbitVelocity == 0.0){
			sine = Math.sin(headingAtLastMove - p.absoluteAngleTo(this));
			orbitVelocity = sine * lastNonZeroVelocity;
		}
		
		double orbitDirection = Utils.sign(orbitVelocity);
		return orbitDirection;
	}
	
	public void calculateDeltas(RobotState previousState){
		if(previousState == null){
			deltasValid = false;
			deltaHeading = 0;
			previousVelocity = 0;
			distanceTraveled = 0;
			timeAtThisSpeed = 0;
			acceleration = 0;
			lastNonZeroVelocity = 1;
			headingAtLastMove = heading;
			return;
		}
		
		long deltaTime = time - previousState.time;
		
		if(deltaTime != 1){
			deltasValid = false;
		}
		
		deltasValid = true;
		
		if(velocity == previousState.velocity){ //if velocities match, no accel
			acceleration = 0.0;
		} else if(Utils.sign(velocity) == Utils.sign(previousState.velocity)){ // if dirs match, difference in speed
			acceleration = Math.abs(velocity) - Math.abs(previousState.velocity);
		} else if(Utils.sign(velocity) == 0) { //came to a stop
			acceleration = -Math.abs(previousState.velocity);
		} else if(Utils.sign(previousState.velocity) == 0){ // starting from a stop
			acceleration = Math.abs(velocity); 
		} else { //switched directions, e.g. 1 -> -1, we count this as acceleration
			acceleration = Math.abs(velocity - previousState.velocity);
		}
		
		acceleration /= deltaTime;
		
		//time at speed
		if(acceleration == 0.0){
			timeAtThisSpeed = previousState.timeAtThisSpeed + deltaTime;
		} else {
			timeAtThisSpeed = 0;
		}
		deltaHeading = Utils.angularDifferenceBetween(previousState.heading, heading);
		
		
		if(Math.abs(velocity) <= 1){
			distanceTraveled = 0;
		} else {
			distanceTraveled = previousState.distanceTraveled + deltaTime * Math.abs(velocity);
		}
		previousVelocity = previousState.velocity;
		
		if(velocity != 0.0){
			lastNonZeroVelocity = velocity;
			headingAtLastMove = heading;
		} else {
			lastNonZeroVelocity = previousState.lastNonZeroVelocity;
			if(lastNonZeroVelocity ==0) lastNonZeroVelocity = 1;
			headingAtLastMove = previousState.headingAtLastMove;
		}
		
		return;
	}
}
