/*
PointInLine v1.0 by Sheldor.  11/24/2012
A NanoBot with random movement + a gun based on stelo.FretNano 1.1's.
Codesize: 245 Bytes without any colors.

Point-in-line is a fencing technique, for more information, see:
https://en.wikipedia.org/wiki/Fencing_terminology#P

Credits:
Thanks go to the authors of the following bots:
stelo.FretNano 1.1, nat.nano.Ocnirp,
and a general thanks to all open source bot authors and contributors to the RoboWiki.

PointInLine is open source and released under the terms of the RoboWiki Public Code License (RWPCL) - Version 1.1
see license here: http://robowiki.net/wiki/RWPCL
*/

package sheldor.nano;

import robocode.*;
import robocode.util.Utils;

public class PointInLine extends AdvancedRobot
{
	//Global variables.
	static double direction;
	private static double enemyX;
	private static double enemyY;
	
	public void run()
	{
		//Start spinning radar and initialize direction to infinity.
		setTurnRadarRightRadians(direction = Double.POSITIVE_INFINITY);
		
		//Keep the gun pointed at its target while the bot turns.
		setAdjustGunForRobotTurn(true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		//Local variables.
		double absoluteBearing;
		
		//Random movement.
		setAhead(direction *= (Math.random() - .08));
		
		//Stay perpendicular to the enemy.
		setTurnRightRadians(Math.cos((absoluteBearing = e.getBearingRadians())));
		
		//Update enemy location variables and fire a wave.
		enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing += getHeadingRadians());
		enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		addCustomEvent(new Wave(getX(), getY(), absoluteBearing));
		
		//Aim gun at the last bearing offset the enemy visited.
    	setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + Wave.bearingOffset));

		//Fire the minimum power needed to destroy the enemy.
		setFire(e.getEnergy() / 4);
		
		//Infinite radar lock.
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
	}

	static class Wave extends Condition
	{	
		//Global variables.	
		double absoluteBearing;
		double gunX;
		double gunY;		
		
		private double distanceTraveled;
		
		static double bearingOffset;
				
		//Initialize this instance of the Wave class.
		public Wave(double _gunX, double _gunY, double _absoluteBearing)
		{
			gunX = _gunX;
			gunY = _gunY;
			absoluteBearing = _absoluteBearing;
		}
	
		public boolean test()
		{
			//Local variables.
			double predictedX;
			double predictedY;
			
			//When the wave hits, calculate the bearing offset.
			if ((distanceTraveled += 11) > Math.hypot(predictedX = (enemyX - gunX), predictedY = (enemyY - gunY)))
			{
				bearingOffset = Math.atan2(predictedX, predictedY) - absoluteBearing;
			}
			return false;
		}
	}

	public void onHitWall(HitWallEvent e)
	{
		//Reverse direction when the bot hits a wall.
		direction = -direction;
	}
}																																																		