package davidalves.net.math;

//Imports for all classes
import robocode.*;
import davidalves.net.*;
import davidalves.net.targeting.*;
import davidalves.net.util.*;
import davidalves.net.movement.*;
import java.util.*;
import java.awt.Color;
import java.io.*;


//Some commonly used math functions
public class DaveMath {//{{{
	
	public static double FULLCIRCLE = 360;
	public static double HALFCIRCLE = 180;
	public static double QUARTERCIRCLE = 90;
	
	static final double[] rangeLimit = {16, 24, 32, 40, 48, 10000};
	
	public static double absoluteAngle(double x1, double y1, double x2, double y2){
		return normalizeAbsoluteAngle(Math.toDegrees(Math.atan2(x2 - x1, y2 - y1)));
	}
	
	public static double absoluteAngle(Point p1, Point p2){
		return absoluteAngle(p1.getX(), p1.getY(), p2.getX(), p2.getY());
	}
	
	//Make sure ang is between 0 and 360
	public static double normalizeAbsoluteAngle(double ang) {
		while (ang > FULLCIRCLE)
			ang -= FULLCIRCLE;
		while (ang < 0)
			ang += FULLCIRCLE;
		return ang;
	}
	
	//Make sure ang is between -180 and 180
	public static double normalizeRelativeAngle(double ang) {
		while (ang > HALFCIRCLE)
			ang -= FULLCIRCLE;
		while (ang < -HALFCIRCLE)
			ang += FULLCIRCLE;
		return ang;
	}
	
	public static double angularDifferenceBetween(double fromAngle, double toAngle){
		return normalizeRelativeAngle(toAngle - fromAngle);
	}
	
	public static double xComponent(double angleInDegrees){
		return Math.cos(Math.toRadians(angleInDegrees - QUARTERCIRCLE));
	}
	
	public static double yComponent(double angleInDegrees){
		return Math.sin(Math.toRadians(angleInDegrees + QUARTERCIRCLE));
	}
	
	public static double powerCorrespondingToSpeed(double speed){
		double theoreticalPower = (20 - speed) / 3;
		return Math.min(Math.max(.1, theoreticalPower), 3);
	}
	
	public static double speedCorrespondingToPower(double power){
		double theoreticalSpeed = 20 - 3 * power;
		return Math.min(Math.max(11, theoreticalSpeed), 19.7);
	}
	
	public static double damageDoneByPower(double power){
		return (power > 1)?(power * 6 - 2):(power * 4);	
	}
	
	public static double energyGainedByHitOfPower(double power){
		return 3 * power;	
	}
	
	public static double maxFiringFrequency(double power, double coolingRate){
		return (1 + power / 5) / coolingRate;
	}
	
	public static double maxForwardDrivingDistance(double currentSpeed, double currentTime){
		double speed = currentSpeed;
		double time = currentTime;
		double maxForwardDrivingDistance = 0;
		while (time > 0){
			if (speed >= 0){
				speed += 1;
				speed = Math.min(speed, 8);
			} else {
				speed += 2;
				speed = Math.max(speed, 0);
			}
			maxForwardDrivingDistance += speed;
			time -= 1;
		}		
		return maxForwardDrivingDistance;
	}

	public static double maxBackwardDrivingDistance(double currentSpeed, double currentTime){
		double speed = currentSpeed;
		double time = currentTime;
		double maxBackwardDrivingDistance = 0;
		while (time > 0){
			if (speed <= 0){
				speed -= 1;
				speed = Math.max(speed, -8);
			} else {
				speed -= 2;
				speed = Math.max(speed, 0);
			}
			maxBackwardDrivingDistance += speed;
			time -= 1;
		}		
		return maxBackwardDrivingDistance;
	}
	
	public static double random(double min, double max){
		return Math.random() * (max - min) + min;
	}
	
	public static int getRangeClass(double range, double bulletPower){
		int rangeClass = 0;
		while((range / DaveMath.speedCorrespondingToPower(bulletPower)) > rangeLimit[rangeClass]){
			rangeClass++;
		}
		return rangeClass;
	}
	
	//Returns the percentage chance that percentageOne and percentageTwo are equivalent, given the
	//number of samples in each percentage
	//TODO: Find out how to do a real t test :-P
	public static double tTest(double percentOne, double percentTwo, double sizeOne, double sizeTwo){
		if(sizeOne < 30 || sizeTwo < 30)
			return 1;
		
		if (sizeOne > sizeTwo){
			double temp = sizeOne;
			sizeOne = sizeTwo;
			sizeTwo = temp;
			
			temp = percentOne;
			percentOne = percentTwo;
			percentTwo = temp;
		}	
		percentOne /= 100;
		percentTwo /= 100;
		
		double n = sizeOne + sizeTwo;
		double percentDifference = Math.abs(percentOne - percentTwo);
		double sizeDifference = Math.abs(sizeOne - sizeTwo);
		//double standardDeviationOne = 1 / sizeOne;
		//double standardDeviationTwo = 1 / sizeTwo;
		
		double standardDeviation = 10 / n;
		//double averageStandardDeviation = standardDeviationOne
		
		
		double probability = 1 / Math.exp(Math.pow(percentDifference / standardDeviation, 2));
		return probability;
	}

	/*  
	// Used to select bullet power
	public static double scaledArcTangent(double minX, double maxX, double minY, double maxY, double scaleX, double offsetX, double x){
		double quartercircle = Math.PI/2;
		double scaleY = (maxY - minY)/((Math.atan(scaleX*((minX-offsetX)/maxX))/quartercircle)-(Math.atan(scaleX*((maxX-offsetX)/maxX))/quartercircle));
		double offsetY = ((minY + maxY)-(scaleY*(Math.atan(scaleX*(minX-offsetX)/maxX)/quartercircle) + scaleY*(Math.atan(scaleX*(maxX-offsetX)/maxX)/quartercircle)))/2;

		return offsetY + scaleY * Math.atan(scaleX*((x-offsetX)/maxX))/quartercircle;
	}
	*/
	
	public static double scaledValue(double scaledMin, double scaledMax, double rawMin, double rawMax, double rawValue){
		return scaledMin + (scaledMax - scaledMin) * (rawValue - rawMin) / (rawMax - rawMin);
		// e.g.     0     + (    1     -     0    ) * ( value   -   0   ) / (1200   -   0   );
		// The above would return "value" between 0 and 1200 scaled to fit between 0 and 1
	}
}