package brainfade.gun;

import java.awt.geom.Point2D;
import brainfade.utils.*;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.util.Utils;

// Referenced classes of package brainfade.utils:
//            Enemy

public class Wave extends Condition
{

    public Wave(AdvancedRobot AR, double firepower, Guess[] stats, Enemy target, Enemy firer)
    {
        this.AR = AR;
        time = AR.getTime()-2;
        bulletSpeed = 20D - 3D * firepower;
        here = new java.awt.geom.Point2D.Double(firer.lastPosition.getX(), firer.lastPosition.getY());
        this.target = target;
        this.firepower = firepower;
        enemyBearing = absoluteBearing(here, target);
        direction = target.direction;
        maxAngle = Math.asin(8D / bulletSpeed);
        distance = target.distance;
        velocity = target.velocity;
        this.stats = stats;
    }

    public boolean test()
    {
        double targetDistance = here.distance(target);
        waveDist = (double)(AR.getTime() - time) * bulletSpeed;
        double bearingDiff = (double)direction * Utils.normalRelativeAngle(absoluteBearing(here, target) - enemyBearing);
        index = (int)Math.min(Math.max(0L, Math.round((bearingDiff / maxAngle) * 12D) + 12D), 24L);
        
        if((waveDist>targetDistance)&&!checked) 
        {
            stats[index].rollingAvg(1);
            checked = true;
            AR.removeCustomEvent(this);
        }
        
        maxIndex = (int)Math.round(Math.min(Math.max(0.0, (((bearingDiff + (20/targetDistance))/ maxAngle) * 12.0) + 12.0), 24.0));
        minIndex = (int)Math.round(Math.min(Math.max(0.0, (((bearingDiff - (20/targetDistance))/ maxAngle) * 12.0) + 12.0), 24.0));
        return true;
    }

    double absoluteBearing(Point2D source, Point2D target)
    {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public Point2D here;
    public double bulletSpeed;
    AdvancedRobot AR;
    Enemy target;
    public Guess[] stats;
    boolean checked = false;
    long time;
    public double velocity;
    public double enemyBearing;
    public int direction;
    public double maxAngle;
    public int index;
    public double firepower;
    public double waveDist = 0;
    public double distance = 0;
    public int maxIndex;// = (int)Math.round(Math.min(Math.max(0.0, (((bearingDiff + (20/targetDistance))/ maxAngle) * 12.0) + 12.0), 24.0));
    public int minIndex;
}


