package ag.team;


/**
 * A simple team information
 * @author agrosse
 *
 */
public class Team_Message implements java.io.Serializable {

	static final long serialVersionUID = 1002;

	public enum Message{
		/**
		 * Message that we have a new team member. mValue[0] is a 
		 * String containing his name. mValue[1] is a boolean 
		 * indicating if the robot sending this message is the 
		 * leader (chooses the target).
		 */
		NEWTEAMMEMBER,
		/**
		 * Message that we are sending robot data. mValue[0] is a Team_RobotData
		 * Object
		 */
		ROBOTDATA,
		/**
		 * Message that a team member died.
		 * mValue[0] is a Boolean indicating if the team member was the leader.
		 */
		TEAMMEMBERDIED,
		/**
		 * Message that a team target was chosen. 
		 * mValue[0] is a String if a target was chosen or null if the team
		 * target has been resetted.
		 */
		TEAMTARGET,
		/**
		 * Message that a bullet of a team member hit an enemy.
		 * mValue[0] is a String containing the name of the enemy that was hit,
		 * mValue[1] is a double with the power of the bullet.
		 */
		BULLETHIT,
		/**
		 * Message that a team member was hit by an enemy bullet.
		 * mValue[0] is a Team_BulletData Object
		 */
		HITBYBULLET,
		/**
		 * Message that a teammate has fired a bullet. mValue[0] is
		 * a Team_BulletData Object
		 */
		FIREDBULLET,
		/**
		 * Message that a teammate collided with a robot. mValue[0] is a
		 * String containing the other robots name
		 */
		ROBOTCOLLISION
		
	};
	
	private Message mMessage;
	private Object mValue[];
	
	/**
	 * Constrctor.
	 * @param info The information tpye for this team information
	 * @param value Vaule of the info
	 */
	public Team_Message(Message msg, Object value[]) {
		super();
		mMessage = msg;
		mValue = value;
	}
	
	/**
	 * Returns the information type
	 * @return the information type
	 */
	public Message getMessage(){
		return mMessage;
	}
	
	/**
	 * Returns the information value
	 * @return the information value
	 */
	public Object[] getValue(){
		return mValue;
	}
	
}
