package ntc;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.*;
import java.awt.Graphics2D;
import java.awt.Color;

/* Knowledge - a robot by Starrynte
 * 1.0 First release (Codesize 547)
       PM gun, simple oscillator movement. 
 * 1.1 Codesize 750
 *     StopAndGo added
 *     Improved oscillator
 *     Changed default HOT to LT
 *     
 */

public class Knowledge extends AdvancedRobot
{
	static double prevHeading,lastEnergy;
	static StringBuilder data=new StringBuilder();
//	static int FORWARD=250;
	static int movement,dir=1;
	
	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		movement=440;
		setTurnRadarRight(prevHeading=Double.NEGATIVE_INFINITY);				
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double absBearing;		
		setTurnRadarRightRadians(Utils.normalRelativeAngle((absBearing=getHeadingRadians()+e.getBearingRadians())-getRadarHeadingRadians())*2);		
		if(prevHeading>=0d){
			data.append((char)(short)((Math.round(e.getVelocity()+8d) << 5) | Math.round(e.getHeading()-prevHeading+10d)));
		}
		double heading=prevHeading=e.getHeading();

		Point2D.Double myPos=new Point2D.Double(getX(),getY());		
		setTurnRight(e.getBearing() + 90 - 30 * Math.signum(e.getDistance()-300) * -Math.signum(getVelocity()*Math.sin(e.getBearingRadians())+1));
		if((getRoundNum()&1)==1){
			if (getDistanceRemaining() == 0 && Math.abs(movement)>40) { setAhead(movement*(dir=-dir)); }
			double delta;
			if((delta=lastEnergy-e.getEnergy())>0d && delta<=3d){			
				setAhead(movement^=400);
			}
			lastEnergy=e.getEnergy();
		}else{
			if (getDistanceRemaining() == 0) { setAhead(Math.sin(getTime()/5)*Math.cos(getTime()/3)*300*(dir=-dir)); }
		}
		setMaxVelocity(Math.random()*10+5);
		

		int index=0;
		int dataLength;
		if((dataLength=data.length())>=40){
		for(int i=5;i<15;i++){
			int tempIndex;
			if((tempIndex=data.substring(5,dataLength-i).indexOf(data.substring(dataLength-i))+5)>-1){
				index=tempIndex+i;
			}
		}
		}
		

		
		double bulletPower=Math.min(Math.max(Math.min(getEnergy()/10d,e.getEnergy()/4d),0.1),3d);		
		double bulletVelocity=Rules.getBulletSpeed(bulletPower);
		if(index<=0 || getGunHeat()*5d>1d){
			setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - getGunHeadingRadians() + (e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing) / bulletVelocity)));	
		}else{			
			Point2D.Double position=projectPoint(absBearing,e.getDistance(),myPos);			
			double bulletDistance=0;				
					
			for(int i=index;i<dataLength;i++){
				short dataChar;	
				int patternHeadDelta=((int)((dataChar=(short)data.charAt(i))&31))-10;				
				double patternVelocity=((double)(((dataChar))>>5))-8d;		
					
				position=projectPoint(Math.toRadians(heading+=patternHeadDelta),patternVelocity,position);
								
				if((bulletDistance+=bulletVelocity)>=position.distance(myPos)){
					break;
				}
			}
			position.setLocation(Math.max(Math.min(position.getX(),782),18),Math.max(Math.min(position.getY(),582),18));
			setTurnGunRightRadians(Utils.normalRelativeAngle(calcAngle(myPos,position)-getGunHeadingRadians()));
		}
		fire(bulletPower);
	}

	public double calcAngle(Point2D.Double source,Point2D.Double target){
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}

	public Point2D.Double projectPoint(double angle, double length, Point2D.Double sourceLocation){
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
	}
	
}
