package lucasslf;

import java.awt.Graphics2D;

import lucasslf.radar.Radar;
import lucasslf.utility.ScannedRobot;
import lucasslf.wavesurfing.WaveSurferMovement;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public abstract class WaveSurferBot extends AdvancedRobot {

	private Radar radar;
	private WaveSurferMovement movement;

	public ScannedRobot lastScannedRobot = new ScannedRobot();
	
	
	
	public void setRadar(Radar radar) {
		this.radar = radar;
	}





	
	
	public void setMovement(WaveSurferMovement movement) {
		this.movement = movement;
	}


	
	

	public Radar getRadar() {
		return radar;
	}







	public WaveSurferMovement getMovement() {
		return movement;
	}







	@Override
	public void onPaint(Graphics2D g) {
		movement.onPaint(g);
		
	}
	
	@Override
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		radar.onBulletHitBullet(e);
		movement.onBulletHitBullet(e);
	}
	
	@Override
	public void onBulletHit(BulletHitEvent e) {
		radar.onBulletHit(e);
		movement.onBulletHit(e);
	}
	
	@Override
	public void onHitByBullet(HitByBulletEvent e) {
		radar.onHitByBullet(e);
		movement.onHitByBullet(e);
	}
	
	@Override
	public void onHitRobot(HitRobotEvent e) {
		radar.onHitRobot(e);
		movement.onHitRobot(e);
	}
	
	@Override
	public void onCustomEvent(CustomEvent e) {
		movement.onCustomEvent(e);
	}
	
	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		movement.onScannedRobot(e);
		radar.onScannedRobot(e);
	}
	
	


	
	
	
}
