package kawigi.spare.parts;
import kawigi.spare.util.*;
import robocode.*;

public class AntiGravityMovement extends MovementStrategy
{
	private GravityManager manager;
	private double maxGravity, minGravity;
	private long nextChange;
	private double direction;
	
	public AntiGravityMovement(AdvancedRobot robot, TargetSelector targetter, GravityManager grav)
	{
		super(robot, targetter);
		manager = grav;
		maxGravity = .01;
		minGravity = .005;
	}
	
	public void onEvent(Event e)
	{
	}
	
	public void setAction()
	{
		manager.update(robot.getTime());
		double force = manager.getTotalForce(robot.getX(), robot.getY());
		System.out.println("total force: " + force);
		if (force > maxGravity)
		{
			System.out.println("TOO MUCH GRAVITY");
			direction = manager.getForceDirection(robot.getX(), robot.getY()) + Math.random()*.2-.1;
			direction = direction - Math.PI/8;
		}
		else if (force < minGravity)
		{
			System.out.println("not enough gravity");
			direction = manager.getNegativeForceDirection(robot.getX(), robot.getY());
			direction = direction - Math.PI/6;
		}
		else
		{
			if (robot.getTime() > nextChange)
			{
				direction = manager.getForceDirection(robot.getX(), robot.getY()) + Math.random()*.50-.25+Math.PI/2;
				if (Math.random()<.5)
					direction = -direction;
				nextChange = robot.getTime()+10;
				System.out.println("Changing random lateral movement");
			}
		}
		if (turnTo(direction))
			robot.setBack(50);			
		else
			robot.setAhead(50);
	}
	
	private boolean turnTo(double direction)
	{
		double theta = direction - robot.getHeadingRadians();
		theta = ((theta-Math.PI)%(Math.PI*2)+2*Math.PI)%(2*Math.PI)-Math.PI;
		
		boolean back = false;
		if (theta > Math.PI/2)
		{
			back = true;
			theta -= Math.PI;
		}
		else if (theta < -Math.PI/2)
		{
			back = true;
			theta += Math.PI;
		}
		if (theta > 0)
			robot.setTurnRightRadians(theta);
		else
			robot.setTurnLeftRadians(-theta);
		return back;
	}
}
