package kawigi.spare.util;

/**
 * GravityVector - keeps track of the power and direction of Gravity
 */
public class GravityVector
{
	private double x, y, strength, power;
	public GravityVector(double posx, double posy, double strength)
	{
		x = posx;
		y = posy;
		this.strength = strength;
		power = 2;
	}
	
	public GravityVector(double posx, double posy, double strength, double power)
	{
		x = posx;
		y = posy;
		this.strength = strength;
		this.power = power;
	}
	
	public double absoluteAngle(double otherx, double othery)
	{
		return Math.atan2(x-otherx, y-othery);
	}
	
	public double force(double otherx, double othery)
	{
		double vx = otherx-x;
		double vy = othery-y;
		return strength/Math.pow((vx*vx+vy*vy)-18, power/2);
	}
	
	public void change(double x, double y, double str)
	{
		this.x = x;
		this.y = y;
		strength = str;
	}
}
