package nat;

import robocode.*;
import wiki.tutorial.GFTargetingBot;
import nat.ether.*;
import nat.ether.utils.M;

import java.awt.*;
import java.awt.geom.*;

public class Hikari extends AdvancedRobot {
	public EtherDrive move;
	public GFTargetingBot basicGun;
	
	private static boolean tickPerformed = false;
	
	public Point2D myLocation;
	public Point2D enemyLocation;
	
	@Override
	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);

		setColors(Color.orange, Color.black, Color.yellow, Color.white, Color.green.brighter().brighter());
		move = new EtherDrive(this);
		basicGun = new GFTargetingBot(this);
		
		do {
			doTick();
			tickPerformed = false;
			scan() ;
		} while (true);
	}
	
	private final void doTick() {
		if (tickPerformed)
			return;
		tickPerformed = true;
		
		if (Math.abs(getRadarTurnRemaining()) < 0.000001) {
			double centerAngle = M.getAngle(new Point2D.Double(getX(), getY()), new Point2D.Double(getBattleFieldWidth()/2d,getBattleFieldHeight()/2d));
			setTurnRadarRightRadians(Double.POSITIVE_INFINITY * M.normalRelativeAngle(centerAngle - getRadarHeadingRadians()));
			if (getTime() > 10)
				System.out.println("Lost radar lock.");
		}
	}
	
	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		double absBearing = e.getBearingRadians() + getHeadingRadians();
		double radarTurn = M.normalRelativeAngle(absBearing - getRadarHeadingRadians());
		radarTurn += M.sign(radarTurn) * M.min(M.RADAR_TURN_RATE, Math.atan(40d / e.getDistance()));
		setTurnRadarRightRadians(radarTurn);
		
		myLocation = new Point2D.Double(getX(), getY());
		enemyLocation = M.project(myLocation, absBearing, e.getDistance());

		basicGun.onScannedRobot(e);
		move.onScannedRobot(e);
	}
	
	@Override
	public void onBulletHit(BulletHitEvent e) {
		move.onBulletHit(e);
	}
	
	@Override
	public void onHitByBullet(HitByBulletEvent e) {
		move.onHitByBullet(e);
	}
	
	@Override
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		move.onBulletHitBullet(e);
	}
	
	@Override
	public void onPaint(Graphics2D g) {
		doTick();
		
		g.setColor(Color.darkGray);
		if (enemyLocation != null) {
			g.draw(new Rectangle2D.Double(myLocation.getX() - 18, myLocation.getY() - 18, 36, 36));
			g.draw(new Rectangle2D.Double(enemyLocation.getX() - 18, enemyLocation.getY() - 18, 36, 36));
		}
		
		move.onPaint(g);
	}
}
