package sgp;
import robocode.*;
import java.util.*;
import java.lang.String;

/**
 * RobotBulletList - a class by Simon Parker
 */

public class RobotBulletList extends Object
{
	LinkedList list = new LinkedList();

	int firedCount = 0;
	int hitCount = 0;
	
	private double firingAngleError = 0.0;
	public double currentLeadAngle = 0;
	

	public void add(RobotBullet bullet)
	{
		list.add(bullet);
		firedCount++;
	}

	public double removeOldBullets(Coordinate targetPosition)
	{
		ListIterator iterator = list.listIterator(0);

		while(iterator.hasNext())
		{
			RobotBullet bullet = (RobotBullet)iterator.next();
			if (bullet.bullet == null) return firingAngleError;

			if (hasMissed(bullet, targetPosition))
			{
				iterator.remove();
			}
			else if (bullet.bullet.getVictim() != null)
			{
				// bullet has hit someone
				hitCount++;
				iterator.remove();
			}
		}
		
		return firingAngleError;
	}

	public double getHitPercentage(Coordinate targetPosition)
	{
		removeOldBullets(targetPosition);

		if (firedCount == 0) return 0.0;
		return (double)hitCount * 100 / (double)firedCount;
	}

	private boolean hasMissed(RobotBullet bullet, Coordinate targetPosition)
	{
		if (bullet.bullet == null) return false;
		if (!bullet.bullet.isActive()) return true;

		Coordinate bulletPosition = bullet.getPosition();
		double distanceToBullet = bullet.startingPosition.distanceFrom(bulletPosition);
		double distanceToTarget = bullet.startingPosition.distanceFrom(targetPosition);

		boolean hasMissedRobot = (distanceToTarget < distanceToBullet);
		
		if (hasMissedRobot) 
		{
			firingAngleError = Strategy.normalRelativeAngle(bullet.bullet.getHeading() - bullet.startingPosition.headingTo(targetPosition));
			
			double w = 0.3;
			currentLeadAngle = - w * firingAngleError + (1 - w) * currentLeadAngle;	

			currentLeadAngle = Strategy.normalRelativeAngle(currentLeadAngle);
		}
		
		return hasMissedRobot;
	}

	public void hit()
	{
		firingAngleError = 0.0;
		hitCount++;
	}
	
	public int getType(Bullet bullet)
	{
		ListIterator iterator = list.listIterator(0);

		while(iterator.hasNext())
		{
			RobotBullet rBullet = (RobotBullet)iterator.next();
			if (rBullet.bullet == bullet) return rBullet.type;
		}
		
		return -1;
		
	}
	
	public double getTotalDistance(Coordinate position)
	{
		double totalDistance = 0;
		
		ListIterator iterator = list.listIterator(0);

		while(iterator.hasNext())
		{
			RobotBullet rBullet = (RobotBullet)iterator.next();
			totalDistance += rBullet.distanceFrom(position);
		}
		
		return totalDistance;
		
	}

}
