package janm;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import java.awt.geom.Point2D;
import java.awt.Color;

/*
 * Jammy - a nanobot by Jan Maes
 * 
 * Movement		: 	Jammy mimics the movement of the opponent
 * Targeting	:	Standard circular targeting technique	
 * Codesize 	: 	249 with color
 * 
 */

public class Jammy extends AdvancedRobot 
{
	
	static double lastEnemyHeading;
	
	public void run() 
	{	
		setColors(Color.white,null,null);
		setAdjustGunForRobotTurn(true);	
		setTurnRadarRight(Double.POSITIVE_INFINITY);		
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		// RADAR
		setTurnRadarLeft(getRadarTurnRemaining());
		
		// MOVEMENT (MIRROR)
		double enemyAbsoluteBearing;		
 		double enemyX;
		double enemyY;
		double angle;
		/*
		 * enemyAbsoluteBearing = enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians()) * e.getDistance();
		 * enemyX = Math.sin(enemyAbsoluteBearing) * e.getDistance();
		 * enemyY = Math.cos(enemyAbsoluteBearing) * e.getDistance();
		 * angle = Utils.normalRelativeAngle(Math.atan2(getBattleFieldWidth() - enemyX - 2*getX(), getBattleFieldHeight() - enemyY - 2*getY()) - getHeadingRadians());
		 * 
		 * To save memory for this nanobot all initialisations are done in place.
		 * 
		 * */
		setTurnRightRadians(angle = Utils.normalRelativeAngle(Math.atan2(getBattleFieldWidth() - (enemyX=Math.sin(enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians()) * e.getDistance()) - 2*getX(), getBattleFieldHeight() - (enemyY=Math.cos(enemyAbsoluteBearing) * e.getDistance()) - 2*getY()) - getHeadingRadians()));	    
		setAhead((angle == Math.atan(Math.tan(angle)) ? 127 : -127));
	    
	    // TARGETING (CIRCULAR PREDICTION)	
		double distance=0;
		double predicted_angle=lastEnemyHeading;
		do
		{
			distance+=11; 
			predicted_angle += e.getHeadingRadians()-lastEnemyHeading;
			enemyX+=e.getVelocity()*Math.sin(predicted_angle);
			enemyY+=e.getVelocity()*Math.cos(predicted_angle);
		}while (distance < Point2D.distance(0,0,enemyX,enemyY));
		lastEnemyHeading=e.getHeadingRadians();
		setTurnGunRightRadians(Utils.normalRelativeAngle(Math.atan2(enemyX, enemyY) - getGunHeadingRadians()));
		fire(3);
	}
}
