package vuen.cfCake;
import vuen.Cake;
import robocode.*;

public class cMovWall {
	private Cake oRobot = null;
	private cMovControl oMovControl = null;
	private cComControl oComControl = null;
	
	public cMovWall(Cake pRobot, cMovControl pMovControl, cComControl pComControl) {
		oRobot = pRobot;
		oMovControl = pMovControl;
		oComControl = pComControl;
	}
	
	public boolean isCoordNearWall(double pX, double pY, double pLineSpace) {
		if (pX > pLineSpace && pX + pLineSpace < oRobot.getBattleFieldWidth() && pY > pLineSpace && pY + pLineSpace < oRobot.getBattleFieldHeight()) 
			return false;
		else
			return true;
	}
	
	public boolean isPolarNearWall(double pAngle, double pDistance, double pLineSpace) {
		//if(true)return false;
		double pX = oRobot.getX() + pDistance * Math.sin(Math.toRadians(pAngle));
		double pY = oRobot.getY() + pDistance * Math.cos(Math.toRadians(pAngle));
		if (pX > pLineSpace && pX + pLineSpace < oRobot.getBattleFieldWidth() && pY > pLineSpace && pY + pLineSpace < oRobot.getBattleFieldHeight()) 
			return false;
		else
			return true;
	}
	
	public boolean isRobotHeadingToWall(double pHeading, double pLineSpace) {
		if (       (oRobot.getY() < pLineSpace && Math.abs(oRobot.normalRelativeAngle(pHeading + 180)) < 89)          ||          (oRobot.getY() > oRobot.getBattleFieldHeight() - pLineSpace && Math.abs(oRobot.normalRelativeAngle(pHeading)) < 89)            ||               (oRobot.getX() < pLineSpace && Math.abs(oRobot.normalRelativeAngle(pHeading + 90)) < 89)                  ||              (oRobot.getX() > oRobot.getBattleFieldWidth() - pLineSpace && Math.abs(oRobot.normalRelativeAngle(pHeading - 90)) < 89))
			return true;
		return false;
	}
}