package dvogon;

import java.awt.Color;
import dvogon.Util;
import robocode.*;

public class GangBang extends AdvancedRobot {
	private int count = 0; // Search turn counter

	private String lastShooter = ""; // Name of last tank that hit us

	private String target = ""; // Current target

	// direction

	/**
	 * run: the main functionality goes here
	 */
	public void run() {
		// Prepare gun
		double gunTurnAmt = -10;
		setAdjustGunForRobotTurn(true); // Keep the gun still when we turn

		while (true) {
			setBodyColor(Color.WHITE);
			turnGunRight(gunTurnAmt);
			count++;

			// Start by looking left
			if (count <= 5) {
				gunTurnAmt = -10;
			}
			// If we haven't seen our target for 5 turns, look right
			if (count > 5) {
				gunTurnAmt = 10;
			}
			// Forget target (if we have one) after 10 turns
			if ((!target.equals("")) && (count > 9)) {
				out.println("Lost sight of " + target);
				target = "";
			}
		}
	}

	/**
	 * onScannedRobot: Hunt and destroy function
	 */
	public void onScannedRobot(ScannedRobotEvent e) {

		// If we have a target, and this isn't it, return immediately
		// so we can get more ScannedRobotEvents.
		if (!(target.equals("") || target.equals(e.getName()))) {
			return;
		}

		// We have a valid target. Hunt and destroy!
		count = 0; // Reset the search counter
		if (target.equals("")) {
			target = e.getName();
			out.println("New target spotted: " + target);
		}

		// Repaint tank in case we have just aquired Target
		paintTank();

		// Always point the gun at Target
		setTurnGunRight(getNormatedGunAngle(e.getBearing()));

		// If far away from Target, move closer
		if (e.getDistance() > 100) {
			setTurnRight(e.getBearing());
			setAhead(e.getDistance() - 70);
		}

		// Shoot if we are close enough
		if (e.getDistance() < 250)
			setFire(3);
		execute(); // Move and fire

		// In close combat mode we circle the enemy
		if (e.getDistance() <= 100) {
			setTurnRight(e.getBearing() - 90);
			setAhead(30);
			execute();
			scan(); // Look for target again to increase fire rate
		}
	}

	/**
	 * onHitRobot: Target robots that hit us
	 */
	@Override
	public void onHitRobot(HitRobotEvent e) {
		if (!target.equals(e.getName())) {
			target = e.getName();
			out.println("Crash with " + target + ". Changing target.");
			setTurnGunRight(getNormatedGunAngle(e.getBearing()));
			setFire(3);
			setBack(50);
			execute();
		}
	}

	/**
	 * onHitByBullet: Target robots that shoot twice at us
	 */
	@Override
	public void onHitByBullet(HitByBulletEvent e) {
		if (!target.equals(e.getName())) {

			if (e.getName().equals(lastShooter)) {
				out.println("Hit twice by " + e.getName()
						+ ". Changing target.");
				target = e.getName();
				setTurnGunRight(getNormatedGunAngle(e.getBearing()));
				execute();
			}
			lastShooter = e.getName();
		}
	}

	/**
	 * onDeath: Release target if it has died
	 */
	@Override
	public void onRobotDeath(RobotDeathEvent e) {
		if (target.equals(e.getName())) {
			out.println("Poor " + target + " died on the battlefield.");
			target = "";
		}
		super.onRobotDeath(e);
	}

	/**
	 * onHitWall: Do evasive manouver after wall hit
	 */
	@Override
	public void onHitWall(HitWallEvent e) {
		setTurnRight(Util.normalRelativeAngle(180 - (e.getBearing() * -1)));
		setAhead(200);
		execute();
	}

	/**
	 * onWin: Do a wictory dance
	 */
	@Override
	public void onWin(WinEvent e) {
		for (int i = 0; i < 50; i++) {
			turnRight(60);
			turnLeft(60);
		}
	}

	public double getNormatedGunAngle(Double bearing) {
		return Util.normalRelativeAngle(bearing
				+ (getHeading() - getRadarHeading()));
	}

	public void paintTank() {
		setColors(Color.ORANGE, Color.ORANGE, Color.BLACK, Color.ORANGE,
				Color.BLACK);
	}

}