/* This is a bot based on the StiX Modular Robot System
 * All navigational, weapons-related, and sensor-related functions
 * are carried out in outside classes, and called from here.
 * The main class is called "Bot" to make modifying the modules easier,
 * instead of having to change the class every time you change the bot name.
 * Set the "package" parameter to what you want the botname to be instead..
 */

package amk.ShizzleStiX;
import robocode.*;
import robocode.util.Utils;
import java.io.*;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.*;

public class ShizzleStiX extends TeamRobot
{
	/* Declare our handlers */
	Sensory Sensors;
	Navigator Navigation;
	Weaponry Weapons;
	
	/* A boolean to say whether or not we are plaing */
	boolean playing = false;
	
	public void run() {
		/* Let the games begin! Assign playing to true to allow the event loop
		 * and create new classes for handling events */
		playing = true;
		Sensors = new Sensory(this);
		Navigation = new Navigator(this);
		Weapons = new Weaponry(this);
		
		/* Add any custom events you may need */
		Sensors.addCustomEvents();
		Navigation.addCustomEvents();
		Weapons.addCustomEvents();
		
		/* Lets make ourselves shexy */
		setColors(new Color(0,50,100),new Color(0,50,100),new Color(0,50,100));

		while(playing) {
			/* Let the classes do their jobs */
			Sensors.run();
			Navigation.run();
			Weapons.run();
			execute();
		}
	}

	/* This is called every time the bot hits a wall */
	public void onHitWall(HitWallEvent e) {
		/* These functions tell our modules that we hit a wall, and hands over
		 * the HitWallEvent for processing */
		Sensors.onHitWall(e);
		Navigation.onHitWall(e);
		Weapons.onHitWall(e);
	}

	/* This is called every time the bot is hit by a bullet */
	public void onHitByBullet(HitByBulletEvent e) {
		/* These functions tell our modules that we were hit, and hands over
		 * the HitByBulletEvent for processing */
		Sensors.onHitByBullet(e);
		Navigation.onHitByBullet(e);
		Weapons.onHitByBullet(e);
	}
	
	/* This is called every time we ran into a robot */
	public void onHitRobot(HitRobotEvent e) {
		/* These functions tell our modules that we ran into a robot,
		 * and hands over the MessageEvent for processing */
		Sensors.onHitRobot(e);
		Navigation.onHitRobot(e);
		Weapons.onHitRobot(e);
	}

	/* This is called every time the bot sees another robot on the field */
	public void onScannedRobot(ScannedRobotEvent e) {
		/* These functions tell our modules that we won, and hands over
		 * the WinEvent for processing */
		Sensors.onScannedRobot(e);
		Navigation.onScannedRobot(e);
		Weapons.onScannedRobot(e);
	}
	
	/* This is called every time a robot on the field dies */
	public void onBulletHit(BulletHitEvent e) {
		/* These functions tell our modules that a bot died, and hands over
		 * the RobotDeathEvent for processing */
		Sensors.onBulletHit(e);
		Navigation.onBulletHit(e);
		Weapons.onBulletHit(e);
	}
	
	/* This is called every time a robot on the field dies */
	public void onBulletMissed(BulletMissedEvent e) {
		/* These functions tell our modules that a bot died, and hands over
		 * the RobotDeathEvent for processing */
		Sensors.onBulletMissed(e);
		Navigation.onBulletMissed(e);
		Weapons.onBulletMissed(e);
	}
	
	/* This is called every time a robot on the field dies */
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		/* These functions tell our modules that a bot died, and hands over
		 * the RobotDeathEvent for processing */
		Sensors.onBulletHitBullet(e);
		Navigation.onBulletHitBullet(e);
		Weapons.onBulletHitBullet(e);
	}

	/* This is called every time a robot on the field dies */
	public void onRobotDeath(RobotDeathEvent e) {
		/* These functions tell our modules that a bot died, and hands over
		 * the RobotDeathEvent for processing */
		Sensors.onRobotDeath(e);
		Navigation.onRobotDeath(e);
		Weapons.onRobotDeath(e);
	}

	/* This is called every time the bot wins a round */
	public void onWin(WinEvent e) {
		/* These functions tell our modules that we won, and hands over
		 * the WinEvent for processing */
		Sensors.onWin(e);
		Navigation.onWin(e);
		Weapons.onWin(e);
		/* Stop the event loop */
		playing = false;
	}
	
	/* This is called every time the bot wins a round */
	public void onDeath(DeathEvent e) {
		/* These functions tell our modules that we died, and hands over
		 * the DeathEvent for processing */
		Sensors.onDeath(e);
		Navigation.onDeath(e);
		Weapons.onDeath(e);
		/* Stop the event loop */
		playing = false;
	}
	
	/* This is called ever time a custom event returns true */
	public void onCustomEvent(CustomEvent e) {
		/* These functions tell our modules that a custom event has occurred,
		 * and hands over the CustomEvent for processing */
		Sensors.onCustomEvent(e);
		Navigation.onCustomEvent(e);
		Weapons.onCustomEvent(e);
	}
	
	/* This is called every time a message is recieved from a teammate */
	public void onMessageReceived(MessageEvent e) {
		/* These functions tell our modules that a message has been recieved,
		 * and hands over the MessageEvent for processing */
		Sensors.onMessageRecieved(e);
		Navigation.onMessageRecieved(e);
		Weapons.onMessageRecieved(e);
	}
}
