package pl.Enemy;

/*******************************************************************************
 * An improvement on Enemy. This includes methods that can tell EnergyDrop, and
 * useful information for various targeting techniques.
 ******************************************************************************/
public class AdvancedEnemy extends Enemy {
	/**
	 * The previous energy of the opponent - useful for detecting energy drop.
	 */
	public double pEnergy;
	/**
	 * The previous heading of the opponent in radians- useful for circular
	 * targeting.
	 */
	public double pHeading;
	/**
	 * The previous velocity of the oponent.
	 */
	public double pVelocity;
	/**
	 * The enemy's previous location's x value.
	 */
	public double pX;
	/**
	 * The enemy's previous location's y value.
	 */
	public double pY;
	/**
	 * The last time the enemy was updated - allows for more accurate
	 * time-related calculations.
	 */
	public long lastUpdated;

	/**
	 * Default constructor. Resets all information.
	 * 
	 * @see Enemy#Enemy()
	 */
	public AdvancedEnemy() {
		super();
		reset();
	}

	/**
	 * Constructor using a ScannedRobotEvent and an AdvancedRobot.
	 * 
	 * @see Enemy#Enemy(ScannedRobotEvent, AdvancedRobot)
	 * 
	 * @param e ScannedRobotEvent
	 * @param r AdvancedRobot that's calling this
	 */
	public AdvancedEnemy(robocode.ScannedRobotEvent e, robocode.AdvancedRobot r) {
		super(e, r);
	}

	/**
	 * Updates the information from a ScannedRobotEvent and an AdvancedRobot.
	 * 
	 * @see Enemy#update(ScannedRobotEvent, AdvancedRobot)
	 * 
	 * @param e ScannedRobotEvent
	 * @param r AdvancedRobot that's calling this
	 */
	public void update(robocode.ScannedRobotEvent e, robocode.AdvancedRobot r) {
		pEnergy = energy;
		pHeading = heading;
		pVelocity = velocity;
		pX = x;
		pY = y;
		lastUpdated = e.getTime();
		super.update(e, r);
	}

	/**
	 * Figures out whether or not a bullet was fired recently.
	 * 
	 * @return true if a bullet was fired, false if not
	 */
	public boolean firedBullet() {
		return (getEnergyChange() <= 3.0 && getEnergyChange() >= 0.1);
	}

	/**
	 * Gets the energy change between now and last updated.
	 * 
	 * @return change in energy
	 */
	public double getEnergyChange() {
		return pEnergy - energy;
	}

	/**
	 * Resets all information except the name.
	 */
	public void reset() {
		pEnergy = 0.0;
		pHeading = 0.0;
		pVelocity = 0.0;
		pX = Double.NaN;
		pY = Double.NaN;
		lastUpdated = 0;
		super.reset();
	}
}