/*
 * Created on 2004-10-11
 */
package tide.pear.statistic;

import tide.util.Statist;
import tide.util.Utils;

/**
 * Basic Statist use to hold a float array with the guess factors in of a bot.
 * @author iiley(Chen Jing)
 */
public class BasicStatist implements Statist {
	
	protected float[] factors;
	protected float   weigh;
	protected int     size;
	protected float   weight = 0.006f;
	
	/**
	 * Create a BasicStatist with guess factors size
	 * @param size guess factors size
	 */
	public BasicStatist(int size, float weigh){
		this.size      = size;
		this.weigh     = weigh;
		this.factors   = new float[size];
	}
	
	public BasicStatist(int size, float weigh, float weight){
		this.size      = size;
		this.weigh     = weigh;
		this.factors   = new float[size];
		this.weight = weight;
	}
	
	/* (non-Javadoc)
	 * @see tide.util.Statist#getFactor(int)
	 */
	public float getFactor(int index) {
		return factors[index];
	}

	/* (non-Javadoc)
	 * @see tide.util.Statist#size()
	 */
	public int size() {
		return size;
	}

	/* (non-Javadoc)
	 * @see tide.util.Statist#rate(int)
	 */
	public void rate(int index) {
		if(index<0 || index >= factors.length){
			return;
		}
		for(int i=0; i<factors.length; i++){
			factors[i]*=(1f - weight);
    	}
		factors[index] += weight;
		
		//Andrew's cool way
		if(index+1 < factors.length){
			factors[index+1] += weight*0.5f;
		}
		if(index-1 >= 0){
			factors[index-1] += weight*0.5f;
		}
		
	}
	
	/* (non-Javadoc)
	 * @see tide.util.Statist#rateToHighest(int)
	 */
	public void rateHit(int index) {
	    int maxVIndex = Utils.maxValueIndex(factors);
	    if(index >= 0 && index < factors.length){
		    //float temp = factors[index];
	    	factors[index] = factors[maxVIndex];
	    	if(index - 1 >= 0){
	    		factors[index - 1] = factors[index] * (1f - weight);
	    	}
	    	if(index + 1 < factors.length){
	    		factors[index + 1] = factors[index] * (1f - weight);
	    	}
	    	//factors[maxVIndex] = temp;
	    }
	}

	/* (non-Javadoc)
	 * @see tide.util.Statist#getHighestFactorIndex()
	 */
	public int getHighestFactorIndex() {
	    return Utils.maxValueIndex(factors);
	}

	/* (non-Javadoc)
	 * @see tide.util.Statist#getCount()
	 */
	public float getWeigh() {
		return weigh;
	}
}
