package kawigi.sbf.core;
import java.awt.geom.*;
import java.util.*;
import java.text.*;
import kawigi.sbf.utils.*;
import robocode.*;
import robocode.peer.*;

/**
 * DuelMovement - embodiment of 1-on-1 movement in FloodHT.
 */
public class DuelMovement
{
	static VolatileEnemy selfEnemy;
	static double direction = 1;
	static double floodDirection = 8;
	
	public static void init()
	{
		selfEnemy = new VolatileEnemy();
	}
	
	public static void move(TeamRobot robot, VolatileEnemy enemy)
	{
		selfEnemy.update(robot);
		int[] indexes = selfEnemy.getSelfSegmentIndexes(enemy);
		int[] segment = Utils.getSelfStats(enemy.name).getSegment(indexes);
		selfEnemy.updateWaves(segment, robot.getTime(), enemy, indexes);
		MovementSimulation sim = new MovementSimulation(robot);
		waveSurf(robot, enemy);
	}
	
	public static void fireSelfWave()
	{
		if (selfEnemy != null && selfEnemy.lastWave != null)
			selfEnemy.lastWave.weight = 1;
	}
	
	public static void floodSurf(TeamRobot robot, VolatileEnemy enemy)
	{
		double bestRisk = findRisk(floodDirection, robot, enemy);
		for (int i=0; i<20; i++)
		{
			double test = Math.max(-8, Math.min(8, Math.random()*20-10));
			double thisrisk = findRisk(test, robot, enemy);
			if (thisrisk <= bestRisk)
			{
				floodDirection = test;
				bestRisk = thisrisk;
			}
		}
		doFloodMove((Moveable)robot, enemy, floodDirection);
	}
	
	public static void waveSurf(TeamRobot robot, VolatileEnemy enemy)
	{
		if (findRisk(-floodDirection, robot, enemy) < findRisk(floodDirection, robot, enemy))
			floodDirection = -floodDirection;
		doFloodMove((Moveable)robot, enemy, floodDirection);
	}
	
	public static void doFloodMove(Moveable robot, VolatileEnemy enemy, double floodDirection)
	{
		double direction = floodDirection < 0 ? -1 : 1;
		Point2D myLocation = new Point2D.Double(robot.getX(), robot.getY());
		double enemyAngle = Utils.angle(enemy, myLocation);
		double moveAngle = enemyAngle + 3*Math.PI/5*direction;
		while (!Utils.inField(Utils.projectPoint(myLocation, moveAngle, 170)))
			moveAngle -= direction/10;
		double turn = moveAngle - robot.getHeadingRadians();
		double moveDirection = 1;
		if (Math.cos(turn) < 0)
		{
			turn += Math.PI;
			moveDirection = -moveDirection;
		}
		robot.setMaxVelocity(Math.abs(floodDirection));
		robot.setTurnRightRadians(turn = Utils.normalize(turn));
		robot.setAhead((Math.abs(turn) > 1) ? 0 : moveDirection*100);
	}
	
	public static double findRisk(double floodDirection, TeamRobot robot, VolatileEnemy enemy)
	{
		long basetime = robot.getTime();
		MovementSimulation sim = new MovementSimulation(robot);
		Rectangle2D[] locations = new Rectangle2D[120];
		for (int offset = 0; offset < 120; offset++)
		{
			locations[offset] = new Rectangle2D.Double(sim.getX()-18, sim.getY()-18, 36, 36);
			doFloodMove(sim, enemy, floodDirection);
			sim.execute();
		}
		double risk = 0;
		int count = 0;
		for (int i=0; i<selfEnemy.bullets.size(); i++)
		{
			WaveBullet b = (WaveBullet)selfEnemy.bullets.get(i);
			if (b.weight != 0)
			{
				count++;
				double thisrisk = 0;
				boolean hasHit = false;
				boolean[] hits = new boolean[Utils.GFS];
				for (int offset = 1; offset < 120; offset++)
				{
					boolean hit = b.addHitGuessFactors(locations[offset], basetime+offset, hits);
					if (hasHit && !hit)
						break;
					if (hit)
						hasHit = true;
				}
				thisrisk = b.hitRisk(hits);
				risk += thisrisk/count;
			}
		}
		return risk;
	}
	
	//Raiko-like movement:
	public static void randomOrbit(TeamRobot robot, VolatileEnemy enemy, boolean random)
	{
		if (enemy == null)
			return;
		
		Point2D myLocation = Utils.getMyLocation();
		
		double bulletTime = myLocation.distance(enemy)/Utils.getBulletVelocity(enemy.lastBulletPower);
		// In theory, I shouldn't need to multiply by the constant.  But in theory, there are no
		// walls and I can change direction instantly.
		if (random && Math.random()*.96 > Math.pow(1/bulletTime, 1/bulletTime))
			direction = -direction;
		
		double enemyAngle = Utils.angle(enemy, myLocation);
		double moveAngle = enemyAngle + 3*Math.PI/5*direction;
		while (Math.abs(moveAngle-enemyAngle) > Math.PI/4 && !Utils.inField(Utils.projectPoint(myLocation, moveAngle, 170)))
			moveAngle -= direction/10;
		if (!Utils.inField(Utils.projectPoint(myLocation, moveAngle, 170)))
		{
			moveAngle = enemyAngle + 3*Math.PI/5*direction;
			if (!Utils.inField(Utils.projectPoint(myLocation, moveAngle, 30)))
			{
				direction = -direction;
				moveAngle = enemyAngle + 3*Math.PI/5*direction;
				while (!Utils.inField(Utils.projectPoint(myLocation, moveAngle, 170)))
					moveAngle -= direction/10;
			}
		}
		double turn = moveAngle - robot.getHeadingRadians();
		double moveDirection = 1;
		if (Math.cos(turn) < 0)
		{
			turn += Math.PI;
			moveDirection = -moveDirection;
		}
		robot.setTurnRightRadians(turn = Utils.normalize(turn));
		robot.setAhead((Math.abs(turn) > 1) ? 0 : moveDirection*100);
	}
	
	public static void hit(Bullet b)
	{
		WaveBullet best = selfEnemy.lastRemovedWave;
		for (int i=0; i<selfEnemy.bullets.size(); i++)
		{
			WaveBullet wave = (WaveBullet)selfEnemy.bullets.get(i);
			if (best == null || best.match(b) > wave.match(b))
				best = wave;
		}
		if (best != null && best.match(b) <= 20)
		{
			best.addBulletStat(b);
		}
	}
	
	public static double getDirection()
	{
		return floodDirection < 0 ? -1 : 1;
	}
}
