package gh;

import robocode.*;
import robocode.util.Utils;
import java.awt.Color;

import gh.ghgun.GresVretter;
import gh.ghmove.WeefSuffurd;
import wiki.mc2k7.RaikoGun;
import gh.ghutils.*;
/**
 * GresSuffurd - a robot by Gert Heijenk
 *
 * GuessFactorTargeting and WaveSurfer movement
 * In the near future also using AntiSurferGun, BulletShadows and maybe Flattener.
 *
 * Pluggable code structure like quite some other bots, specific credit to Voidious' Dookious
 * Ofcourse the codebase itself is from GresSuffurd
 *
 * Code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/cgi-bin/robowiki?RWPCL
 */
public class GresSuffurd extends AdvancedRobot
{
    private static boolean TC_flag = false;
    private static boolean MC_flag = false;
    private static boolean MC2K7_flag = false;
    
	private WeefSuffurd movement;
	private GresVretter gunnery;
	private static RaikoGun   raikogun;

	static int skipturn;

	private boolean WIN_flag = false;		// continue flow until safe

	/**
	 * run: Grmbl's default behavior
	 */
	public void run() {

		if (movement == null) {
			movement = new WeefSuffurd( this);
			if (MC2K7_flag) {
				raikogun = new RaikoGun( this);
			} else {
				gunnery  = new GresVretter( this, TC_flag);
			}
		}
		TickState.reset( this);
        // Let gun and radar move independently
		setAdjustGunForRobotTurn( true);
		setAdjustRadarForGunTurn( true);
		// Give the robot an appealing look
		setColors( Color.red, Color.red.darker().darker().darker(), Color.red.darker().darker());

		// Start the mainloop
		while( !WIN_flag) {
			if (getRadarTurnRemaining() == 0.0)
       			setTurnRadarLeftRadians( Math.PI);
			execute();
		}
		
		// I won, but continue movement until all potential bullets have passed
		while (movement.simulatedScannedRobot() == false) {
			execute();
		}
		postponedWinningParty();
	}

	/**
	 * onScannedRobot: What to do when you see another robot (just save everything and do nothing here)
	 */
	public void onScannedRobot( ScannedRobotEvent e) {

		TickState.onScannedRobot( this, e);
		if (TC_flag == false) {
			movement.onScannedRobot( e);
		}
		if (MC2K7_flag) {
			raikogun.onScannedRobot( e);
		} else if (MC_flag == false) {
			gunnery.onScannedRobot (e);
		}

		if (!MC2K7_flag) {
			TickState.doCheckRadar( this);
		} else {
			// for some reason the radar of raikogun does not work correctly
			double radarBearingOffset = 
    			Utils.normalRelativeAngle(getRadarHeadingRadians() - 
    				(e.getBearingRadians() + getHeadingRadians()));
			setTurnRadarLeftRadians(radarBearingOffset * 2);
		}
	}

	// onHitRobot: I don't wanna be hit by anyone
	public void onHitRobot( HitRobotEvent e)
	{
		TickState.onHitRobot( e);
	}

	// onHitWall:  I don't wanna hit the wall.
	public void onHitWall( HitWallEvent e)
	{
		TickState.onHitWall( e);
	}

	/**
	 * onBulletHit: Yes, I hit somebody
	 */
	public void onBulletHit(BulletHitEvent e)
	{
		TickState.onBulletHit( this, e);
		movement.onBulletHit( e);
		if (!MC2K7_flag) { gunnery.onBulletHit( e); }
	}

	/**
	 * onBulletMissed: Damn, I missed (again)
	 */
	public void onBulletMissed(BulletMissedEvent e)
	{
		TickState.onBulletMissed( e);
//		if (!MC2K7_flag) { gunnery.onBulletMissed( e); }
	}

	/**
	 * onHitByBullet:  I am hit, handle some (movement) statistics.
	 */
	public void onHitByBullet( HitByBulletEvent e)
	{
		TickState.onHitByBullet( e);
		movement.onHitByBullet( e);
//		if (!MC2K7_flag) { gunnery.onHitByBullet( e); }
	}

	/**
	 * onBulletHitBullet:  The bullets hit eachother, see if I can do something with it
	 */
	public void onBulletHitBullet( BulletHitBulletEvent e)
	{
		TickState.onBulletHitBullet( e);
		movement.onBulletHitBullet( e);
		if (!MC2K7_flag) { gunnery.onBulletHitBullet( e); }
	}

	/**
	 * onSkippedTurn:  Handle a skipped turn.
	 */
	public void onSkippedTurn(SkippedTurnEvent e)
	{
		skipturn++;
//		out.println(getTime()+" AAaaaarghhhhh");
	}

	/**
	 * onWin: Show my private victory dance
	 */
	public void onWin(WinEvent e)
	{
		// remember some variables
		WIN_flag = true;
		if (!MC2K7_flag) { gunnery.onWin( e); }
//		out.println(getTime() + " I've won !");
	}

	/**
	 * postponedWinningParty: Show my private victory dance
	 */
	public void postponedWinningParty( )
	{
		printStats();
		//Victory dance, well at least the movement	
		setTurnRight(1);
		ahead(0);
		waitFor(new RadarTurnCompleteCondition(this));
	}

	/**
	 * onDeath: Show some statistics
	 */
	public void onDeath(DeathEvent e)
	{
//		movement.onDeath( e);
		if (!MC2K7_flag) { gunnery.onDeath( e); }
		printStats();
	}


	/**
	 * printStats: Print statistics on end of round
	 */
	public void printStats( )
	{
		boolean lastRound = ((getRoundNum() + 1) == getNumRounds());
		if (lastRound == true) {
			if (skipturn > 0) 
				out.println("SkipTurns  :" + skipturn);
		}
		TickState.printStats();
		if (!MC2K7_flag) { gunnery.printStats(); }
		movement.printStats();
	}

}
