package hamilton;

import robocode.*;
import java.util.*;

public class RadarManager 
{
	AdvancedRobot r;
	TargetManager t;
	
	public RadarManager(AdvancedRobot someR, TargetManager someT)
	{
		r = someR;
		t = someT;
	}
	
	public void doDuel()
	{
		if (t.getTargetsScanned() < r.getOthers()) r.setTurnRadarRightRadians(2 * Math.PI);
		
		else
		{
			Iterator i = t.getTargetIterator();
			
			if (i.hasNext())
			{
				Target currentRadarTarget = (Target)i.next();
				
				double elapsedTime = r.getTime() - currentRadarTarget.getTimeStamp();

				Coordinate robotCoordinates = new Coordinate(r.getX(), r.getY());
				
				double radarTargetDistance = robotCoordinates.distanceFrom(currentRadarTarget.getCoordinates());				

				double bearing = robotCoordinates.absoluteBearingTo(currentRadarTarget.getCoordinates());
				double turnAmount = Calculator.relativeAngle(bearing - r.getRadarHeadingRadians());

				double radarTurnTime = Math.abs(turnAmount) / (Math.PI / 2);
				
				double possibleDisplacement = (elapsedTime + radarTurnTime) * 8;
				
				double uncertainty = possibleDisplacement / radarTargetDistance;

				if (turnAmount > 0) turnAmount = Calculator.relativeAngle(turnAmount + uncertainty);
				else turnAmount = Calculator.relativeAngle(turnAmount - uncertainty);
				
				r.setTurnRadarRightRadians(turnAmount);
				
			}
		}
	}
	
	public void doMelee()
	{
		if (t.getTargetsScanned() < r.getOthers()) r.setTurnRadarRightRadians(2 * Math.PI);
		
		else if (Math.abs(r.getRadarTurnRemainingRadians()) < (Math.PI / 20) )
		{
			double time = r.getTime();
			Coordinate robotCoordinates = new Coordinate(r.getX(), r.getY());
			
			Iterator i = t.getTargetIterator();
			
			double minimumDistance;
			double turnAmount = 0;
			Target currentRadarTarget;
			
			if (i.hasNext())
			{
				currentRadarTarget = (Target)i.next();
				
				double radarTargetDistance = robotCoordinates.distanceFrom(currentRadarTarget.getCoordinates());
				double elapsedTime = r.getTime() - currentRadarTarget.getTimeStamp();				
				double possibleDisplacement = elapsedTime * 8;
				double someMinimumDistance = radarTargetDistance - possibleDisplacement;
				if (someMinimumDistance < 0) someMinimumDistance = 0;
				
				minimumDistance = someMinimumDistance;
				
				while (i.hasNext())
				{
					Target someTarget = (Target)i.next();
					
					double someTargetDistance = robotCoordinates.distanceFrom(someTarget.getCoordinates());
					double someTargetElapsedTime = r.getTime() - someTarget.getTimeStamp();
					double someTargetPossibleDisplacement = someTargetElapsedTime * 8;
					someMinimumDistance = someTargetDistance - someTargetPossibleDisplacement;
					if (someMinimumDistance < 0) someMinimumDistance = 0;
							
					if (someMinimumDistance < minimumDistance)
					{
						currentRadarTarget = someTarget;
						minimumDistance = someMinimumDistance;
						radarTargetDistance = someTargetDistance;
						elapsedTime = someTargetElapsedTime;
					}
				}
				
				double bearing = robotCoordinates.absoluteBearingTo(currentRadarTarget.getCoordinates());
				turnAmount = Calculator.relativeAngle(bearing - r.getRadarHeadingRadians());

				double radarTurnTime = Math.abs(turnAmount) / (Math.PI / 2);
				
				possibleDisplacement = (elapsedTime + radarTurnTime) * 8;
				
				double uncertainty = possibleDisplacement / radarTargetDistance;
				if (uncertainty < Math.PI / 8) uncertainty = Math.PI / 8;

				if (turnAmount > 0) turnAmount = Calculator.relativeAngle(turnAmount + uncertainty);
				else turnAmount = Calculator.relativeAngle(turnAmount - uncertainty);
			}
		
			r.setTurnRadarRightRadians(turnAmount);
		}
	}
}
