package axeBots.okami;
import robocode.*;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.io.*;
import java.awt.Shape;
import java.awt.geom.*;

import axeBots.AxeBot;
import axeBots.util.*;

public class AxeTargetMan {
    private AxeTarget targets[]= null;
    private Vector fifo= new Vector();
    private boolean duel;

    private int opps= 0;
    private int maxOpps= 0;
    private PrintStream log= null;
    private AxeTarget target= null;
    // private boolean rstPts= false;

    private Rectangle2D.Double qNE;
    private Rectangle2D.Double qNW;
    private Rectangle2D.Double qSE;
    private Rectangle2D.Double qSW;

    public static final int CHS_CENTERNORMAL= 0;
    public static final int CHS_BESTAVG= 1;
    private int targetChoose= CHS_BESTAVG;

    private BulletRadar bullRadar= new BulletRadar();

    private ArrayList scores= new ArrayList();

    public void terminate() {
        //log.println("AxeTargetMan.terminate()");

        for (int i= 0; i < maxOpps; i++) {
            if (targets[i] != null) {

                targets[i].terminate();
            }
        }

        orderTargetsByScore();

        Collections.reverse(scores);
        Iterator it= scores.iterator();

        //        while (it.hasNext()) {
        //            log.println("===> SCORE: " + it.next());
        //        }

        //putStats();

        //summarizeToFile();
        //resetTarget();

    }

    public AxeTargetMan(double h, double w) {
        //maxOpps = opps = qtd;
        log= AxeBot.getIt().out;
        ////log.println("instanciou AxeTargetMan oponentes:"+maxOpps);
        qNE= new Rectangle2D.Double(w / 2, h, w / 2, h / 2);
        qNW= new Rectangle2D.Double(0, h, w / 2, h / 2);
        qSE= new Rectangle2D.Double(w, h, w / 2, h / 2);
        qSW= new Rectangle2D.Double(0, 0, w / 2, h / 2);
    }

    public ArrayList getHeadlight() {
        ArrayList inFront= new ArrayList();
        //		AffineTransform  atx = 
        //			   AffineTransform.getRotateInstance(-Math.PI/6,40,50); 
        //			// Take the shape object and create a rotated version 
        //			Shape atShape = atx.createTransformedShape(shape1); 
        //			g2.draw(atShape); 
        //
        //			
        //		for (int i= 0; i < targets.length; i++) {
        //					if ((targets[i] != null) && (targets[i].isAlive())) {
        //						meToHim= new AxeVector(me.pos(), targets[i].pos());
        //
        //						//                log.println(targets[i].getName()+" meToHim: "+meToHim);
        //						double score= targets[i].getStratego().getScore().getAvgScore();
        //						score= (score < 1) ? 1 : score;
        //						double weight= targets[i].getLastEnergy() * score;
        //						mod= (weight / Math.pow(targets[i].getDistance(), 2)) * (-1);
        //						meToHim.setModule(mod);
        //
        //						ag.relativePlus(meToHim);
        //
        //						//				log.println(targets[i].getName()+" apos ag. modulo:"+mod+" meToHim: "+meToHim+" ag:"+ag);
        //					}
        //				}

        return inFront;

    }

    public int getOpps() {
        return opps;
    }

    public int getMaxOpps() {
        return maxOpps;
    }

    public int inFront(Arc2D.Double arc) {
        //        int ret= 0;
        //        for (int i= 0; i < targets.length; i++) {
        //            if (targets[i] != null) {
        //
        //                if (targets[i].isAlive()) {
        //                    if (arc.contains(targets[i].getX(), targets[i].getY())) {
        //                        //log.println(" na frente:"+targets[i].getName()+" "+targets[i].getX()+"," +targets[i].getY());
        //                        ret++;
        //                    }
        //                    //else
        //                    //log.println(" FORA:"+targets[i].getName()+" "+targets[i].getX()+"," +targets[i].getY());
        //                }
        //            }
        //        }
        //        return ret;
        return botsInShape(arc).size();
    }

    public AxeVector antiGrav(boolean useDist) {
        AxeBot me= AxeBot.getIt();
        AxeVector ag= new AxeVector(me.pos(), me.pos());
        AxeVector meToHim;
        double mod;

        for (int i= 0; i < targets.length; i++) {
            if ((targets[i] != null) && (targets[i].isAlive())) {
                meToHim= new AxeVector(me.pos(), targets[i].pos());

                //                log.println(targets[i].getName()+" meToHim: "+meToHim);
                double score= targets[i].getStratego().getScore().getAvgScore();
                score= (score < 1) ? 1 : score;
                double weight= targets[i].getLastEnergy() * score;

                mod=
                    (useDist)
                        ? (weight / Math.pow(targets[i].getDistance(), 3))
                        : weight;
                mod *= -1;
                meToHim.setModule(mod);

                ag.relativePlus(meToHim);

                //				log.println(targets[i].getName()+" apos ag. modulo:"+mod+" meToHim: "+meToHim+" ag:"+ag);
            }
        }

        //corners(?)
        //        double cornerWeight= 20;
        //
        //        Point2D.Double ne= new Point2D.Double(0, me.getBattleFieldHeight());
        //        Point2D.Double nw=
        //            new Point2D.Double(
        //                me.getBattleFieldWidth(),
        //                me.getBattleFieldHeight());
        //        Point2D.Double se= new Point2D.Double(0, 0);
        //        Point2D.Double sw= new Point2D.Double(me.getBattleFieldWidth(), 0);
        //
        //        meToHim= new AxeVector(me.pos(), ne);
        //        mod= cornerWeight * (-1);
        //        meToHim.setModule(mod / ne.distanceSq(me.pos()));
        //        ag.relativePlus(meToHim);
        //
        //        meToHim= new AxeVector(me.pos(), nw);
        //        mod= cornerWeight * (-1);
        //        meToHim.setModule(mod / nw.distanceSq(me.pos()));
        //        ag.relativePlus(meToHim);
        //
        //        meToHim= new AxeVector(me.pos(), se);
        //        mod= cornerWeight * (-1);
        //        meToHim.setModule(mod / se.distanceSq(me.pos()));
        //        ag.relativePlus(meToHim);
        //
        //        meToHim= new AxeVector(me.pos(), sw);
        //        mod= cornerWeight * (-1);
        //        meToHim.setModule(mod / sw.distanceSq(me.pos()));
        //        ag.relativePlus(meToHim);

        return ag;
    }

    private Vector botsInShape(Shape s) {
        Vector ret= new Vector();
        for (int i= 0; i < targets.length; i++) {
            if ((targets[i] != null)
                && (targets[i].isAlive())
                && (targets[i].isIn(s))) {
                ret.addElement(targets[i]);
            }
        }
        return ret;
    }

    ArrayList getFarol(int len) {
        AxeBot me= AxeBot.getIt();

        double dx= me.getWidth();
        double dy= me.getHeight();
        Area farol= null;
        len= Math.abs(len);
        //        if(len <0){
        //        	len*=-1;
        //			farol=
        //						new Area(
        //							new Rectangle2D.Double(
        //								me.pos().x - (dx / 2),
        //								me.pos().y -len,
        //								dx,
        //								len));
        //        	
        //        }else{

        Rectangle2D.Double farolRect=
            new Rectangle2D.Double(
                me.pos().x - (dx / 2),
                me.pos().y + (dy / 2),
                dx,
                len);
        //        me.out.println(" Farol rect:" + farolRect + " pos:" + me.pos());
        farol= new Area(farolRect);
        //        }
        int farolLen= 100;

        new Area(
            new Rectangle2D.Double(
                me.pos().x - (dx / 2),
                me.pos().y + (dy / 2),
                dx,
                len));
        double ang= me.getHeadingDegrees();

        if (me.isRe()) {
            ang -= 180;
        }

        ang= RoboMath.normalAbsoluteAngle(ang);

        // Create a rotation transform of 30degrees CCW around
        // the the corner of the rectangle. 
        AffineTransform atx=
            AffineTransform.getRotateInstance(
                Math.toRadians(ang),
                me.pos().x,
                me.pos().y);
        // Take the shape object and create a rotated version 
        farol= new Area(atx.createTransformedShape(farol));

        ArrayList ret= new ArrayList();
        for (int i= 0; i < targets.length; i++) {
            if ((targets[i] != null) && (targets[i].isAlive())) {
                Area bot= new Area(targets[i].getBotShape());
                bot.intersect(farol);
                if (!bot.isEmpty()) {
                    //                    log.println(" FAROL: " + targets[i].getName());
                    ret.add(targets[i]);
                }
            }
        }
        return ret;
    }

    public int botsInSquare(Shape s, double distance) {
        int ret= 0;
        Vector inShape= botsInShape(s);
        for (int i= 0; i < inShape.size(); i++) {
            if (targets[i].getDistance() <= distance) {
                ret++;
            }
        }
        return ret;
    }

    //    public AxeVector getBestMoveTo() {
    //        AxeVector sum= null;
    //        for (int i= 0; i < targets.length; i++) {
    //            if (targets[i] != null) {
    //
    //                if (targets[i].isAlive()) {
    //                    AxeVector targToCenter=
    //                        this.getTargetCenterVector(targets[i]);
    //                    //log.println("BOT:"+targets[i].getName()+" angulo relativo ao centro:"+targToCenter.getRelativeTheta()+" modulo:" +targToCenter.getRelativeModule() );
    //                    if (sum == null) {
    //                        sum= targToCenter;
    //                    } else {
    //                        sum.relativePlus(targToCenter);
    //                    }
    //                }
    //            }
    //        }
    //        //log.println("SOMATORIO angulo relativo ao centro:"+sum.getRelativeTheta()+" modulo:" +sum.getRelativeModule()+" invertido:" + RoboMath.getInverseNormRelAng(sum.getRelativeTheta()) );
    //        return sum;
    //    }

    //    public  Rectangle2D.Double getBestCenter() {
    //        int opsNE= 0;
    //        int opsSE= 0;
    //        int opsSW= 0;
    //        int opsNW= 0;
    //
    //        for (int i= 0; i < targets.length; i++) {
    //            if (targets[i] != null) {
    //
    //                if (targets[i].isAlive()) {
    //                    if (qNE.contains(targets[i].getX(), targets[i].getY())) {
    //                        opsNE++;
    //                    } else if (
    //                        qNW.contains(targets[i].getX(), targets[i].getY())) {
    //                        opsNW++;
    //                    } else if (
    //                        qSE.contains(targets[i].getX(), targets[i].getY())) {
    //                        opsSE++;
    //                    } else if (
    //                        qSW.contains(targets[i].getX(), targets[i].getY())) {
    //                        opsSW++;
    //                    }
    //                }
    //            }
    //        }
    //
    //        if ((opsNE <= opsNW) && (opsNE <= opsSW) && (opsNE <= opsSE)) {
    //            return qNE;
    //        } else if ((opsSE <= opsNW) && (opsSE <= opsSW) && (opsSE <= opsNE)) {
    //            return qSE;
    //        } else if ((opsNW <= opsNE) && (opsNW <= opsSW) && (opsNW <= opsSE)) {
    //            return qNW;
    //        } else if ((opsSW <= opsNW) && (opsSW <= opsNE) && (opsSW <= opsSE)) {
    //            return qSW;
    //        }
    //        return null;
    //    }

    public void setDuel(boolean d) {
        duel= d;
        for (int i= 0; i < maxOpps; i++) {
            if (targets[i] != null) {
                targets[i].setDuel(d);

            }
        }
    }

    //    public void resetPts() {
    //        //log.println("AXETARGETMAN RST TRUE");
    //        rstPts= true;
    //    }

    public boolean allScanned(double since) {
        //if(opps < maxOpps) return true; else return false;

        for (int i= 0; i < targets.length; i++) {
            if (targets[i] != null) {

                if (targets[i].isAlive()) {
                    if (targets[i].getScanTime() < since) {
                        //log.println("allScanned false:"+targets[i].getName()+" scan em:"+targets[i].getScanTime()+" since:"+since);
                        return false;
                    }
                }
            } else
                return false;
        }
        return true;
    }

    public double getLowestEnemyBearing(double x, double y, double ref) {
        double ret= Double.NaN;
        double test;
        //AxeVector al = null;
        //int p = 0;
        ref= RoboMath.normalRelativeAngle(ref);
        for (int i= 0; i < targets.length; i++) {
            if (targets[i] != null) {
                if (targets[i].isAlive()) {
                    test=
                        RoboMath.normalRelativeAngle(
                            (
                                (AxeVector)targets[i]
                                    .getAllPos()
                                    .lastElement())
                                    .getRelativeTheta(
                                x,
                                y));
                    test= RoboMath.normalRelativeAngle(test - ref);
                    if (Double.isNaN(ret)) {
                        ret= test;
                        //				al = ((AxeVector)targets[i].getAllPos().lastElement());
                        //				p = i;
                    } else if (test < ret) {
                        ret= test;
                        //					al = ((AxeVector)targets[i].getAllPos().lastElement());
                        //					p = i;
                    }
                }
            }
        }
        //log.println("getLowestEnemyBearing:"+ret+" x,y:"+al.getX()+","+al.getY()+" targets x,y:"+targets[p].getX()+","+targets[p].getY()+" "+targets[p].getName());
        return ret;
    }

    public double getHightestEnemyBearing(double x, double y, double ref) {
        double ret= Double.NaN;
        double test;
        //AxeVector al = null;
        //int p = 0;
        ref= RoboMath.normalRelativeAngle(ref);
        for (int i= 0; i < targets.length; i++) {
            if (targets[i] != null) {
                if (targets[i].isAlive()) {
                    test=
                        RoboMath.normalRelativeAngle(
                            (
                                (AxeVector)targets[i]
                                    .getAllPos()
                                    .lastElement())
                                    .getRelativeTheta(
                                x,
                                y));
                    test= RoboMath.normalRelativeAngle(test - ref);
                    if (Double.isNaN(ret)) {
                        ret= test;
                        //				al = ((AxeVector)targets[i].getAllPos().lastElement());
                        //				p = i;
                    } else if (test > ret) {
                        ret= test;
                        //					al = ((AxeVector)targets[i].getAllPos().lastElement());
                        //					p = i;
                    }
                }
            }
        }
        //log.println("getHightestEnemyBearing:"+ret+" x,y:"+al.getX()+","+al.getY()+" targets x,y:"+targets[p].getX()+","+targets[p].getY()+" "+targets[p].getName());
        return ret;
    }

    public void setMaxOpps(int m) {
        if (maxOpps == 0) {
            maxOpps= m;
            targets= new AxeTarget[maxOpps];
        }
    }

    //    public  void setLog(PrintStream o) {
    //        //if(maxOpps == 0)
    //        log= o;
    //
    //    }

    public void hitMe(String name, double power) {
        AxeTarget it= getBot(name);
        if (it != null) {
        	it.setExpectedLifeDiff(power * 3D);
            it.hitMe(RoboMath.getBulletDamage(power));
            //resetTarget();
        }
        if (target != null)
            if (target.getHitMe() == 0)
                target= null;
    }

    //    public void putStats() {
    //        log.println("____________________________________");
    //        log.println("ESTATISTICAS:");
    //        String stats = null;
    //        for (int i = 0; i < maxOpps; i++) {
    //            if (targets[i] != null) {
    //                stats = targets[i].getStats();
    //                log.println(stats);
    //                log.println();
    //            }
    //        }
    //
    //        log.println("____________________________________");
    //    }

    public void missed(BulletTracker bt) {
        AxeTarget busca= getBot(bt.getTargetName());

        if (busca != null) {
            busca.missed(bt);
        }

    }

    public void fired(BulletTracker bt) {
        //log.println(">>>>>>>>>>>>>>>>   HHHHHHHHHHIIIIIIIIIIIIITTTTTTTTTTT!!!!!!!!!!! "+bt.getTargetName()+" aim:"+bt.getAimMethod());//+" Life:"+bt.getEnergy());
        AxeTarget busca= getBot(bt.getTargetName());

        if (busca != null) {
            busca.fired();
        }
    }

    public void hit(BulletTracker bt) {
        //log.println(">>>>>>>>>>>>>>>>   HHHHHHHHHHIIIIIIIIIIIIITTTTTTTTTTT!!!!!!!!!!! "+bt.getTargetName()+" aim:"+bt.getAimMethod());//+" Life:"+bt.getEnergy());
        AxeTarget busca= getBot(bt.getTargetName());

        if (busca != null) {
            busca.hit(bt);
        }
    }

    //    public void killedBy(String bot) {
    //        //log.println(">>>>>>>>>>>>>>>>   HHHHHHHHHHIIIIIIIIIIIIITTTTTTTTTTT!!!!!!!!!!! "+bt.getTargetName()+" aim:"+bt.getAimMethod());//+" Life:"+bt.getEnergy());
    //        AxeTarget busca= getBot(bot);
    //
    //        if (busca != null) {
    //            busca.killedMe();
    //        }
    //    }

    public Vector getAllClose(int dist) {

        Vector ret= new Vector();

        for (int i= 0; i < targets.length; i++) {
            if ((targets[i] != null)
                && (targets[i].isAlive())
                && (targets[i].getDistance() < dist)) {
                //HataMoto.getIt().out.println("                 ========----- "+targets[i].getName() +"  ====>> "+bot);
                ret.addElement(targets[i]);
            }
        }

        //        if (ret.size() == 0)
        //            return null;
        //        else
        return ret;
    }

    public Vector getTargeting(String bot) {
        Vector ret= new Vector();

        for (int i= 0; i < targets.length; i++) {
            if ((targets[i] != null)
                && (targets[i].isAlive())
                //&& (targets[i].getStratego().goodFire(targets[i]))
                && (targets[i].getAlvo() != null)
                && (targets[i].getAlvo().equals(bot))) {
                //HataMoto.getIt().out.println("                 ========----- "+targets[i].getName() +"  ====>> "+bot);
                ret.addElement(targets[i]);
            }
        }

        if (ret.size() == 0)
            return null;
        else
            return ret;
    }

    public boolean inCrossFire() {
        int moveAmount= 60;
        AxeBot me= AxeBot.getIt();
        AxeVector myMoving=
            new AxeVector(
                me.getX(),
                me.getY(),
                me.getMoveHeading(),
                moveAmount);

        Line2D.Double myLine=
            new Line2D.Double(myMoving.getStartPoint(), myMoving.getEndPoint());

        for (int i= 0; i < targets.length; i++) {
            if ((targets[i] != null) && (targets[i].isAlive())) {
                AxeTarget aimed= this.getBot(targets[i].getAlvo());
                if ((aimed != null) && (aimed.isAlive())) {
                    Line2D.Double fireLine=
                        new Line2D.Double(
                            targets[i].getX(),
                            targets[i].getY(),
                            aimed.getX(),
                            aimed.getY());

                    if (myLine.intersectsLine(fireLine)) {
                        //                        me.out.println(
                        //                            "      *********  CROSSFIRE ******* "
                        //                                + targets[i].getName()
                        //                                + "  -->  "
                        //                                + aimed.getName());
                        return true;
                    }
                }
            }
        }
        return false;

    }

    public void printAllTargets() {

        AxeBot.getIt().out.println("*****************************");
        for (int i= 0; i < targets.length; i++) {
            if (targets[i] != null) {
                if (targets[i].isAlive()) {

                    AxeBot.getIt().out.println(
                        ""
                            + targets[i].getName()
                            + "  ====>> "
                            + targets[i].getAlvo());

                }
            }
        }
        AxeBot.getIt().out.println("*****************************");

    }

    /**
    	 * @return
    	 */
    public double getCanHitMe(String bot) {
        AxeTarget robot= this.getBot(bot);
        if ((robot != null) || (!robot.isAlive())) {
            return robot.getCanHitMe();
        } else
            return Double.NaN;
    }

    /**
     * @param d
     */
    public void resetCanHitMe(String bot) {
        AxeTarget robot= this.getBot(bot);
        if ((robot != null) || (!robot.isAlive())) {
            robot.setCanHitMe(Double.NaN);
        }
    }

    public void setScanned(ScannedRobotEvent e, AdvancedRobot ft) {

        AxeTarget busca= getBot(e.getName());

        if (busca != null) {

            busca.setScanned(e, ft);
            //log.println(">>>>>>>>>>>> scaneou ==> "+e.getName()+" enrgy:"+busca.getLastEnergy()+" dif:"+busca.getLastLifeDiff() );

            String atackerName= this.bullRadar.test(busca);
            AxeTarget atacker= getBot(atackerName);

            if (atacker != null) {
                atacker.setAlvo(busca.getName());
            }

            //log.println("scaneou ==> "+e.getName());
            //if(
        } else {
            //log.println("scaneou novo. armazenando ==> "+e.getName());
            putBot(e, ft);
        }

        /*if(target==null)
        {
        	
        	if(fifo.size()>0)
        	{
        		resetTarget();
        	}
        	//else
        	//{
        	//	target = 
        	//}
        }*/
        //target.setScanned(e,ft);
    }

    public double getFirePwr(AdvancedRobot ft, Arc2D.Double arc, AxeTarget t) {
        if (t != null) {
            int inf= this.inFront(arc);
            return t.getStratego().setFirePower();
        } else
            return Double.NaN;
    }

    //    public double getGun(AdvancedRobot ft, double firePower) {
    //        if (target != null) {
    //            return target.getGun(ft, firePower, getAimStrat());
    //        } else
    //            return Double.NaN;
    //    }

    private int getAimStrat() {
        return target.getStratego().getAimStrat();
    }

    public int getBestMoving() {
        if (target != null) {
            return target.getStratego().getMoving();
        } else
            return 0;
    }

    //    public int newAimStrat() {
    //        return target.newAimStrat();
    //    }

    public boolean notSeenSince(double time) {
        if (target != null) {
            return (time > (target.getScanTime() + 10));
        }

        return false;
    }

    public AxeTarget getTarget(int opps) {
        if ((target == null)
            || (!target.isAlive())
            || (target.getHitsOnARow() < 2)) {
            getPrimeTarget(opps);
        }
        return target; //(AxeTarget)target.clone();

    }

    public void anotherOneBitesTheDust(RobotDeathEvent e, int pts) {
        AxeTarget jaera= getBot(e.getName());
        pts= (maxOpps + 1) - (pts + 1);
        //pts + 1 pque a eu existo!!!pts e o numero de restantes.
        if (jaera != null) {
            jaera.dead(pts);
        }
    }
    /*
    private  void resetTarget()
    {
    	//log.println("resetTarget fifo.size:"+fifo.size());
    	orderTarget();
    	AxeTarget busca = null;
    	
    	if(fifo.size() == 0)
    	{
    		//log.println("NAO EXISTE PROXIMO NA LISTA DE ALVOS.");
    		target = busca;
    		return;
    	}
    	
    	while(fifo.size()>0)
    	{
    			String next = (String)fifo.firstElement();
    			//log.println("ASSUMINDO PROXIMO NA LISTA DE ALVOS("+fifo.size()+"):"+next);
    			fifo.removeElementAt(0);
    			busca = getBot(next);
    			
    			if(busca.isAlive())
    				break;
    			else
    				//log.println("MORTO. PROXIMO...");
    		}
    		target = busca;
    		
    			
    }
    
    private void orderTarget()
    {
    	Vector order = new Vector();
    	Vector antes = new Vector();
    	//antes.copyInto(targets);
    	
    	for(int i=0; i<targets.length; i++)
    	{
    		if(targets[i] != null)
    		{
    			antes.addElement(targets[i]);
    			//log.println(targets[i].getName()+" damaged me:"+targets[i].getHitMe());
    		}
    	}
    	
    	int c = 0;
    	int val = 0;
    	while(antes.size()>0)
    	{
    		c=0;
    		val = ((AxeTarget)antes.firstElement()).getHitMe();
    		for(int i=1; i < antes.size(); i++)
    		{
    			if(((AxeTarget)antes.elementAt(i)).getHitMe() > val)
    			{
    				c=i;
    				val = ((AxeTarget)antes.elementAt(i)).getHitMe();
    			}
    		}
    		order.addElement(((AxeTarget)antes.elementAt(c)).getName());
    		antes.removeElementAt(c);
    	}
    	
    	fifo = (Vector)order.clone();
    			
    }
    */
    public AxeTarget getTooClose(double minDist) {
        AxeTarget ret= null;
        for (int i= 0; i < targets.length; i++) {
            if ((targets[i] != null)
                && (targets[i].isAlive())
                && (targets[i].getDistance() < minDist)) {
                if (ret == null)
                    ret= targets[i];
                else if (targets[i].getDistance() < ret.getDistance())
                    ret= targets[i];
            }
        }
        return ret;
    }

    private AxeTarget getDisabled() {
        //AxeTarget ret = null;
        for (int i= 0; i < targets.length; i++) {
            if (targets[i] != null) {
                if (targets[i].isAlive()) {
                    if (targets[i].getLastEnergy() < (0.1)) {
                        return targets[i];
                    }
                }
            }
        }
        return null;
    }

    private double getCenterBearing() {
        AxeVector me=
            new AxeVector(
                AxeBot.getIt().getBattleFieldWidth() / 2.0,
                AxeBot.getIt().getBattleFieldHeight() / 2.0);
        return me.getRelativeTheta(
            AxeBot.getIt().getX(),
            AxeBot.getIt().getY());

        //AxeVector me = new AxeVector(HataMoto.getIt().getX(),HataMoto.getIt().getY());
        //return me.getRelativeTheta(HataMoto.getIt().getBattleFieldWidth()/2.0,HataMoto.getIt().getBattleFieldHeight()/2.0);
    }

    private double getTargetCenterNormal(AxeTarget targ) {
        //log.println(targ.getName()+"getTargetCenterNormal center:"+RoboMath.normalRelativeAngle(getCenterBearing())
        //			+" tbear:" +RoboMath.normalRelativeAngle(Math.toDegrees(targ.getAbsBearing())));
        double ret=
            (double)RoboMath.normalRelativeAngle(
                RoboMath.normalRelativeAngle(getCenterBearing())
                    - RoboMath.normalRelativeAngle(
                        Math.toDegrees(targ.getAbsBearing())));
        //if(ret<0) ret *= -1;

        /*log.println(targ.getName()+"getTargetCenterNormal center:"+RoboMath.normalRelativeAngle(getCenterBearing())
        			+" tbear:" +RoboMath.normalRelativeAngle(Math.toDegrees(targ.getAbsBearing()))+" ret:"+ret);*/
        return Math.abs(ret);
    }

    //    private AxeVector getTargetCenterVector(AxeTarget targ) {
    //        AxeVector targToCenter= new AxeVector(targ.getX(), targ.getY());
    //        //AxeVector targToCenter = new AxeVector(HataMoto.getIt().getBattleFieldWidth()/2.0,HataMoto.getIt().getBattleFieldHeight()/2.0);
    //        targToCenter.setOrigin(
    //            HataMoto.getIt().getBattleFieldWidth() / 2.0,
    //            HataMoto.getIt().getBattleFieldHeight() / 2.0);
    //        targToCenter.setModule(1);
    //        return targToCenter;
    //
    //    }

    private void getPrimeTarget(int opps) {
        AxeBot me= AxeBot.getIt();
        double close= me.getBotDim() * 8;

        int energyLim= 25;

        if (target != null) {
            if (!target.isAlive()) {
                if (me.getOthers() > 0) {

                    target= null;
                }else{
                	return;
                }
            }
            //            else if ((target.getDistance() <= close)) {
            //                return;
            //            }
        }

        //        if (me.getEnergy() < energyLim) {

        //        AxeTarget tooClose= getTooClose(close); //300);
        //        if (tooClose != null) {
        //            //log.println("getPrimeTarget tooClose:"+tooClose.getName());
        //            target= tooClose;
        //            return;
        //        }
        //        }
        //        AxeTarget disabled= getDisabled();
        //        if (disabled != null) {
        //            //log.println("getPrimeTarget disabled:"+disabled.getName());
        //            target= disabled;
        //            return;
        //        }

        /*
        if(opps == 2)
        {
        	if(target != null)
        	{
        		
        		if(target.isAlive() && (target.getTargetMisses() < 5))
        		{
        			//log.println("getPrimeTarget:"+target.getName()+" getTargetMisses:"+target.getTargetMisses());
        			return;
        		}
        		
        	}
        	
        	for(int i=0; i < targets.length; i++)
        			{
        				if(targets[i] != null)
        				{
        					if(targets[i].isAlive()&&(targets[i].getTargetMisses() < 5))
        					{
        						if(target != null)
        							target.resetTargetMisses();
        						
        						target = targets[i]; 
        						//log.println("getPrimeTarget menos de 2 muda:"+target.getName()+" getTargetMisses:"+target.getTargetMisses());
        						
        						return;
        					}
        				}
        			}
        	//log.println("getPrimeTarget menos de 2 e nao mudou.");
        }
        */

        Vector targVector= this.getAllClose((int)close);
        Object[] targArray;
        if ((targVector != null) && (targVector.size() > 0)) {
            targArray= targVector.toArray();
        } else {
            targArray= targets;
        }

        //		Vector aimingMe= this.getTargeting(me.getName());
        //				Object[] aimMe;
        //				if ((aimingMe != null) && (aimingMe.size() > 0)) {
        //					aimMe= aimingMe.toArray();
        //				} else {
        //					aimMe= targets;
        //				}

        //		se tres opps OU MENOS , pega o +fraco (DOS QUE ESTAO ATIRANDO EM MIM.
        if (opps < 4) {
            //aimMe= targets;

            AxeTarget next= null;
            double norm= 0;
            for (int i= 0; i < targArray.length; i++) {
                AxeTarget now= (AxeTarget)targArray[i];
                if ((now != null) && (now.isAlive())) {
                    double cp;

                    cp=
                        now.getStratego().getBestAvg(
                            now.getDistance(),
                            now.getAngle())
                            * 100.00;
                    cp += 100 - now.getLastEnergy();
                    double groupPrize=
                        10
                            * (inFront(me.getAimingArc(now.getAbsBearing(), 20))
                                - 1);
                    cp += groupPrize;
                    if ((next == null) || (cp > norm)) {
                        norm= cp;
                        next= now;
                    }
                }
            }
            if (next != null) {
                target= next;
                //log.println("getPrimeTarget escolheu:"+target.getName());
            }
            //            return;
            //
            //            AxeTarget weaker= null;
            //            for (int i= 0; i < aimMe.length; i++) {
            //                AxeTarget now= ((AxeTarget)aimMe[i]);
            //                if ((now != null)
            //                    && (now.isAlive())
            //                    && now.getStratego().goodFire(now.getDistance())) {
            //                    if (weaker == null) {
            //                        weaker= now;
            //                    } else if (now.getLastEnergy() < weaker.getLastEnergy()) {
            //                        weaker= now;
            //                    }
            //                }
            //            }
            //
            //            if (weaker != null) {
            //                //log.println("getPrimeTarget weaker:"+weaker.getName()+"  en:" +weaker.getLastEnergy());
            //                target= weaker;
            //                return;
            //            }
        }
        AxeTarget next= null;
        double norm= 0;
        switch (targetChoose) {

            case CHS_CENTERNORMAL :
                // aimMe= targets;
                for (int i= 0; i < targArray.length; i++) {
                    AxeTarget now= (AxeTarget)targArray[i];
                    if ((now != null) && (now.isAlive())) {
                        double cp;
                        if (me.getEnergy() < energyLim) {
                            cp=
                                now.getStratego().getBestAvg(
                                    now.getDistance(),
                                    now.getAngle())
                                    * 100.00;
                            cp += 100 - now.getLastEnergy();
                            double groupPrize=
                                10
                                    * (inFront(me
                                        .getAimingArc(now.getAbsBearing(), 20))
                                        - 1);
                            cp += groupPrize;
                        } else {
                            // pega a normal em relaccao ao centro.
                            cp= getTargetCenterNormal(now);
                            // adiciona bonus 10*grupo
                            double groupPrize=
                                10
                                    * (inFront(me
                                        .getAimingArc(now.getAbsBearing(), 20))
                                        - 1);
                            cp += groupPrize;
                            //adiciona bonus se atual alvo
                            if ((target != null)
                                && (target.getName().compareTo(now.getName())
                                    == 0)) {
                                cp += 10;
                            } // adiciona bonus se alvo me atacando
                            if ((now.getAlvo() != null)
                                && (now
                                    .getAlvo()
                                    .equals(AxeBot.getIt().getName()))) {
                                cp += 20;
                            } //adiciona bonus de score e danos causados
                            double scr= this.getScorePoints(now.getName());
                            double dmg= this.getDamagePoints(now.getName());
                            cp += this.getScorePoints(now.getName());
                            cp += this.getDamagePoints(now.getName());
                        } //log.println("getPrimeTarget points:"+now.getName()+" :" +cp+" score:"+scr+" damaged:"+dmg);
                        if ((next == null) || (cp > norm)) {
                            norm= cp;
                            next= now;
                        }
                    }
                }
                if (next != null) {
                    target= next;
                    //log.println("getPrimeTarget escolheu:"+target.getName());
                }
                break;

            case CHS_BESTAVG :
                //aimMe= targets;
                //escolhe o melhor dentre os outros
                for (int i= 0; i < targArray.length; i++) {
                    AxeTarget now= (AxeTarget)targArray[i];
                    if ((now != null) && (now.isAlive())) {
                        double cp;

                        cp=
                            (now.getStratego().getAimTotFiredInRange(now)
                                > (Stratego.AIM_STRATS * 5))
                                ? now.getStratego().getBestAvg(
                                    now.getDistance(),
                                    now.getAngle())
                                    * 100.00
                                : 100.00;

                        //	adiciona bonus 10*grupo
                        double groupPrize=
                            10
                                * (inFront(me
                                    .getAimingArc(now.getAbsBearing(), 20))
                                    - 1);
                        cp += groupPrize;
                        //	adiciona bonus se alvo me atacando
                        if ((now.getAlvo() != null)
                            && (now.getAlvo().equals(AxeBot.getIt().getName()))) {
                            cp += 20;
                        }
                        //	adiciona bonus se atual alvo
                        if ((target != null)
                            && (target.getName().compareTo(now.getName()) == 0)) {
                            cp += 10;
                        }

                        if ((next == null) || (cp > norm)) {
                            norm= cp;
                            next= now;
                        }
                    }
                }
                if (next != null) {
                    target= next;
                    //log.println("getPrimeTarget escolheu:"+target.getName());
                }
                break;

        }

    }

    public AxeTarget getBot(String bot) { ////log.println("getBot searching:"+bot);
        if (bot != null) {
            AxeTarget busca= null;
            for (int i= 0; i < maxOpps; i++) {
                busca= targets[i];
                if (busca != null) {
                    ////log.println("tentando:"+busca.getName());
                    if (busca.getName().compareTo(bot) == 0) {
                        ////log.println("getBot:"+busca.getName());
                        return busca;
                    }
                } //else
                //log.println("busca nulo");
            }
        }

        return null;
    }

    private void putBot(ScannedRobotEvent e, AdvancedRobot ft) {
        AxeTarget t= new AxeTarget(e, ft, log);
        t.setDuel(duel);
        scores.add(t.getStratego().getScore());
        AxeTarget busca= null;
        for (int i= 0; i < maxOpps; i++) {
            busca= targets[i];
            if (busca == null) {
                busca= t;
                targets[i]= t;
                //fifo.addElement(t.getName());
                opps++;
                //log.println("ADICIONANDO INIMIGO:"+t.getName());
                return;
            }

        }

    } //    private void scanDir() {
    //        try {
    //            //Vector bots = new Vector();
    //
    //            String dataFileName= "estatisticas_totais.txt";
    //
    //            PrintStream p=
    //                new PrintStream(
    //                    new RobocodeFileOutputStream(
    //                        HataMoto.getIt().getDataFile(dataFileName)));
    //
    //            //Vector allAvg = new Vector();
    //
    //            File dbgPath= HataMoto.getIt().getDataDirectory();
    //            String[] logList= dbgPath.list();
    //
    //            //log.println("DIR: "+ dbgPath.getPath());
    //            for (int i= 0; i < logList.length; i++) {
    //                File atual= new File(dbgPath.getPath() + "\\" + logList[i]);
    //
    //                String name= atual.getName();
    //                name=
    //                    name.substring(
    //                        name.indexOf("_") + 1,
    //                        name.lastIndexOf("."));
    //
    //                //log.println(name);
    //
    //                if (atual.isFile()) {
    //                    AxeTarget t= new AxeTarget(name, log, rstPts);
    //                    Vector estim= new Vector();
    //                    Vector names= new Vector();
    //
    //                    p.println("______________________________");
    //                    p.println(t.getName());
    //                    p.println("DUEL:");
    //                    t.setDuel(true);
    //                    estim= t.getAvgHitVector();
    //                    names= t.getNamesVector();
    //                    this.writeLn(names, estim, p);
    //                    t.setDuel(false);
    //                    p.println("MELEE:");
    //                    estim= t.getAvgHitVector();
    //                    this.writeLn(names, estim, p);
    //
    //                } else {
    //                    //System.out.println("atual: ["+atual.getName()+"] NAO e' arquivo");
    //                    //max++;
    //                }
    //                //GhostDebug.write(this.getClass().getName(), logList[i]+" "+listado.getName()+" "+Long.toString(listado.length()));
    //            }
    //            p.close();
    //        } catch (Throwable e) {
    //            log.println(e.getMessage() + ":" + e.getStackTrace());
    //        }
    //    }
    //    private void summarizeToFile() {
    //        PrintStream p = null;
    //        try {
    //            //Vector bots = new Vector();
    //
    //            String dataFileName = "totais.txt";
    //
    //            p =
    //                new PrintStream(
    //                    new RobocodeFileOutputStream(
    //                        HataMoto.getIt().getDataFile(dataFileName)));
    //
    //            //Vector allAvg = new Vector();
    //
    //            File dbgPath = HataMoto.getIt().getDataDirectory();
    //            String[] logList = dbgPath.list();
    //
    //            ArrayList totsDuel = new ArrayList();
    //            ArrayList totsMelee = new ArrayList();
    //
    //            ArrayList bots = new ArrayList();
    //
    //            //log.println("DIR: "+ dbgPath.getPath());
    //            for (int i = 0; i < logList.length; i++) {
    //                File atual = new File(dbgPath.getPath() + "\\" + logList[i]);
    //
    //                String name = atual.getName();
    //
    //                int prefIndex = name.indexOf(Stratego.STAT_FILE_PREFIX);
    //                if (prefIndex == 0) {
    //
    //                    name =
    //                        name.substring(
    //                            Stratego.STAT_FILE_PREFIX.length(),
    //                            name.lastIndexOf("."));
    //                } else {
    //                    continue;
    //                }
    //
    //                if (atual.isFile()) {
    //                    //log.println("SUMARIZANDO "+name);
    //                    bots.add(new AxeTarget(name, log));
    //                }
    //            }
    //
    //            Collections.sort(bots, new Comparator() {
    //                public int compare(Object a, Object b) {
    //                    double diff =
    //                        ((AxeTarget)a).getStratego().getScore().getAvgScore()
    //                            - ((AxeTarget)b)
    //                                .getStratego()
    //                                .getScore()
    //                                .getAvgScore();
    //                    if (diff < 0)
    //                        return 1;
    //                    if (diff > 0)
    //                        return -1;
    //                    return 0;
    //
    //                }
    //            });
    //
    //            Iterator botsIt = bots.iterator();
    //            while (botsIt.hasNext()) {
    //                AxeTarget t = (AxeTarget)botsIt.next();
    //                ArrayList duel = t.getStratego().getDuelAimStats();
    //                ArrayList melee = t.getStratego().getMeleeAimStats();
    //
    //                Iterator it = duel.iterator();
    //                Iterator itTot = totsDuel.iterator();
    //
    //                if (totsDuel.isEmpty()) {
    //                    while (it.hasNext()) {
    //                        totsDuel.add(it.next());
    //                    }
    //                } else {
    //                    while (it.hasNext()) {
    //                        ((AxeAimingStrats)itTot.next()).add(
    //                            (AxeAimingStrats)it.next());
    //                    }
    //                }
    //
    //                it = melee.iterator();
    //                itTot = totsMelee.iterator();
    //                if (totsMelee.isEmpty()) {
    //                    while (it.hasNext()) {
    //                        totsMelee.add(it.next());
    //                    }
    //                } else {
    //                    while (it.hasNext()) {
    //                        ((AxeAimingStrats)itTot.next()).add(
    //                            (AxeAimingStrats)it.next());
    //                    }
    //                }
    //
    //                //                    if (totsDuel.size() == 0) {
    //                //                        for (int j= 0; j < duel.size(); j++) {
    //                //                            totsDuel.addElement(duel.elementAt(j));
    //                //                            totsMelee.addElement(melee.elementAt(j));
    //                //                        }
    //                //                    } else {
    //                //                        for (int j= 0; j < duel.size(); j++) {
    //                //                            ((AimStrat)totsDuel.elementAt(j)).add(
    //                //                                (AimStrat)duel.elementAt(j));
    //                //                            ((AimStrat)totsMelee.elementAt(j)).add(
    //                //                                (AimStrat)melee.elementAt(j));
    //                //                        }
    //                //                    }
    //
    //                p.println("BOT: " + t.getName());
    //
    //                p.println();
    //                p.println("SCORES:");
    //                ArrayList scoring = t.getStratego().getAllScores();
    //                it = scoring.iterator();
    //                while (it.hasNext()) {
    //                    p.println(it.next());
    //                }
    //
    //                p.println();
    //                p.println("MOVING STATISTICS:");
    //                ArrayList movings = t.getStratego().getMovings();
    //                it = movings.iterator();
    //                while (it.hasNext()) {
    //                    p.println(it.next());
    //                }
    //
    //                p.println();
    //                p.println("AIMING STATISTICS:");
    //
    //                this.writeSummary(duel, p);
    //                p.println();
    //                this.writeSummary(melee, p);
    //                p.println();
    //                p.println("______________________________");
    //                p.println();
    //
    //                //GhostDebug.write(this.getClass().getName(), logList[i]+" "+listado.getName()+" "+Long.toString(listado.length()));
    //            }
    //
    //            p.println("TOTAIS");
    //            p.println();
    //            p.println("AIMING STATISTICS:");
    //            p.println();
    //            this.writeSummary(totsDuel, p);
    //            p.println();
    //            this.writeSummary(totsMelee, p);
    //            p.println();
    //            p.println("______________________________");
    //
    //        } catch (Throwable e) {
    //            StackTraceElement ste[] = e.getStackTrace();
    //            log.println(e.getMessage());
    //            for (int k = 0; k < ste.length; k++) {
    //                log.println(ste[k]);
    //            }
    //        } finally {
    //            p.close();
    //        }
    //    }
    //
    //    private void writeSummary(ArrayList ts, PrintStream ps) {
    //        Collections.sort(ts);
    //
    //        StringColumnFormat frm = new StringColumnFormat();
    //        ts = frm.format(ts);
    //
    //        Iterator it = ts.iterator();
    //
    //        //log.println("linhas:" + ts.size());
    //        while (it.hasNext()) {
    //            ps.println(it.next());
    //        }
    //    }
    private double getScorePoints(String bot) {

        double pointsWidth= 20;
        double pointsStep= pointsWidth / (double) (this.getMaxOpps() - 1);
        orderTargetsByScore();
        AxeScoreReg srch= new AxeScoreReg(bot, this.getMaxOpps() + 1);
        int ind= scores.indexOf(srch);
        if (ind > -1) {
            return ind * pointsStep;
        } else {
            return 0;
        }
    }

    private void orderTargetsByScore() {
        Collections.sort(scores, new Comparator() {
            public int compare(Object a, Object b) {
                double diff=
                    ((AxeScoreReg)a).getAvgScore()
                        - ((AxeScoreReg)b).getAvgScore();
                if (diff < 0)
                    return -1;
                if (diff > 0)
                    return 1;
                return 0;
            }
        });
    }

    private void orderTargetsByDamage() {
        Collections.sort(scores, new Comparator() {
            public int compare(Object a, Object b) {
                double diff=
                    ((AxeScoreReg)a).getAvgDamage()
                        - ((AxeScoreReg)b).getAvgDamage();
                if (diff < 0)
                    return -1;
                if (diff > 0)
                    return 1;
                return 0;
            }
        });
    }

    private double getDamagePoints(String bot) {

        double pointsWidth= 20;
        double pointsStep= pointsWidth / (double) (this.getMaxOpps() - 1);
        orderTargetsByDamage();
        AxeScoreReg srch= new AxeScoreReg(bot, this.getMaxOpps() + 1);
        int ind= scores.indexOf(srch);
        if (ind > -1) {
            return ind * pointsStep;
        } else {
            return 0;
        }
    }

}
