package axeBots.util;
//import java.util.Vector;
import java.awt.geom.*;
import java.util.ArrayList;

import axeBots.AxeBot;
import axeBots.okami.AxeVector;

public class RoboMath {
    public static final int NONE= 0;
    public static final int NORTE= 1;
    public static final int SUL= 2;
    public static final int LESTE= 4;
    public static final int OESTE= 8;
    public static final int ALL= NORTE + SUL + LESTE + OESTE;

    public static final int NW= 1;
    public static final int NE= 2;
    public static final int SW= 3;
    public static final int SE= 4;

    public static final double PI= Math.PI; //just a constant
    //if a bearing is not within the -pi to pi range, alters it to provide the shortest angle
    public static double NormaliseBearing(double ang) {
        if (ang > PI)
            ang -= 2 * PI;
        if (ang < -PI)
            ang += 2 * PI;
        return ang;
    }

    public static int countBits(int val) {
        return (int)Math.ceil(RoboMath.log((val + 1), 2));
    }

    public static double getRollingAvg(
        double average,
        double count,
        double newValue) {

        //from Paul Evans idea.
        if (count == 0) {
            count= 1;
            average= newValue;
        } else {
            average= (average * count + newValue) / (count + 1);
            count= count + 1;
        }

        return average;

    }

    public static void rollAvgs(double[] vec, int index, int count) {
        for (int i= 0; i < vec.length; i++) {
            vec[i]= getRollingAvg(vec[i], count, (index == i) ? 1 : 0);
        }
    }

    public static double log(double val, double base) {
        return Math.log(val) / Math.log(base);
    }
    
	public static int estimateBullTravelTime(double pow, double dist) {
				double lastBVel= RoboMath.getBulletVelocity(pow);
				double timeToHit= dist / lastBVel;
				return (int)Math.round(timeToHit);
			}

    public static double accelerateBotLinear(
        AxeVector vec,
        double head,
        double vel,
        double newVel,
        double maxTime) {

        double diffVel= newVel - vel;
        if (diffVel == 0) {
            return 0;
        }
        double time= 0;

        Point2D.Double pos= vec.getEndPoint();
        double newY= pos.y + Math.cos(head) * vel * time;
        double newX= pos.x + Math.sin(head) * vel * time;

        pos.setLocation(newX, newY);
        return time;
    }

    public static Point2D.Double moveBotLinear(
        Point2D.Double pos,
        double head,
        double vel,
        double time) {
        double newY= pos.y + Math.cos(head) * vel * time;
        double newX= pos.x + Math.sin(head) * vel * time;
        pos= (Point2D.Double)pos.clone();
        pos.setLocation(newX, newY);
        return pos;
    }

    public static Point2D.Double moveBotCircular(
        Point2D.Double pos,
        double head,
        double headsDelta,
        double tvel,
        double time) {

        if (Math.abs(headsDelta) < 0.00001) {
            return moveBotLinear(pos, head, tvel, time);
        }

        double radius= tvel / headsDelta;
        double tothead= time * headsDelta;

        double newY=
            pos.y
                + (Math.sin(head + tothead) * radius)
                - (Math.sin(head) * radius);
        double newX=
            pos.x
                + (Math.cos(head) * radius)
                - (Math.cos(head + tothead) * radius);
        pos= (Point2D.Double)pos.clone();
        pos.setLocation(newX, newY);
        return pos;
    }

    public static boolean restrictToField(Point2D.Double p, AxeBot me) {
        double targetMiddle= Math.max(me.getWidth(), me.getHeight()) / 2;
        double maxX= me.getBattleFieldWidth();
        double maxY= me.getBattleFieldHeight();
        double minY= 0;
        double minX= 0;

        boolean restricted= false;
        if ((p.x) < minX) {
            restricted= true;
            p.x= minX + targetMiddle;
        }
        if ((p.y) < minY) {
            restricted= true;
            p.y= minY + targetMiddle;
        }
        if ((p.x) > maxX) {
            restricted= true;
            p.x= maxX - targetMiddle;
        }
        if ((p.y) > maxY) {
            restricted= true;
            p.y= maxY - targetMiddle;
        }
        return restricted;
    }

    //if a heading is not within the 0 to 2pi range, alters it to provide the shortest angle
    public static double NormaliseHeading(double ang) {
        if (ang > 2 * PI)
            ang -= 2 * PI;
        if (ang < 0)
            ang += 2 * PI;
        return ang;
    }

    //	public static double getInverseNormRelAng(double ang) {
    //		return (normalRelativeAngle(ang+180));
    //	}

    /**
     * Returns the damage a bullet with that energy inflincts
     * @param energy the bullets energy
     * @return the damage a bullet with that energy inflincts
     */
    public static double distToWall(Point2D.Double pt) {
        Rectangle2D.Double field= AxeBot.getIt().getField();
        return (
            Math.min(
                Math.min((pt.x - field.getMinX()), (field.getMaxX() - pt.x)),
                Math.min((pt.y - field.getMinY()), (field.getMaxY() - pt.y))));
    }

    public static double distToCorner(Point2D.Double pt) {
        Rectangle2D.Double field= AxeBot.getIt().getField();
        return (
            Math.min(
                Math.min(
                    pt.distance(field.getMinX(), field.getMinY()),
                    pt.distance(field.getMinX(), field.getMaxY())),
                Math.min(
                    pt.distance(field.getMaxX(), field.getMinY()),
                    pt.distance(field.getMaxX(), field.getMaxY()))));
    }

    public static double getBulletDamage(double energy) {
        double damage= 4 * energy;

        if (energy > 1)
            damage += 2 * (energy - 1);

        return damage;
    }

    public static double bulletDamageToEnergy(double damage) {
        double energy;

        if (damage <= 4) {

            energy= damage / 4;
        } else {
            energy= (damage + 2) / 6;
        }

        return energy;
    }

    public static double getBulletVelocity(double energy) {
        double speed= 20 - (3 * energy);
        return speed;
    }

    public static double getrange(Point2D.Double p1, Point2D.Double p2) {
        return RoboMath.getrange(p1.x, p1.y, p2.x, p2.y);
    }

    public static double getang(Point2D.Double p1, Point2D.Double p2) {
        return RoboMath.getang(p1.x, p1.y, p2.x, p2.y);
    }

    public static double getNRDegrees(Point2D.Double p1, Point2D.Double p2) {
        return RoboMath.normalRelativeAngle(
            Math.toDegrees(RoboMath.getang(p1.x, p1.y, p2.x, p2.y)));
    }

    

    public static double getStandDeviation(
        double sum,
        double squaredSum,
        int samples) {
        return ((samples * (squaredSum)) - Math.pow(sum, 2))
            / (samples * (samples - 1));
    }

    //returns the distance between two x,y coordinates
    public static double getrange(double x1, double y1, double x2, double y2) {
        double xo= x2 - x1;
        double yo= y2 - y1;
        double h= Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    //returns the angle between two x,y coordinates
    public static double getang(double x1, double y1, double x2, double y2) {
        double xo= x2 - x1;
        double yo= y2 - y1;
        double teta= Math.PI / 2 - Math.atan2(yo, xo);
        //double h = Math.sqrt( xo*xo + yo*yo );
        return teta; //Math.toRad(teta);	
    }

    public static double getMax(double[] array) {
        if (array == null)
            return 0;

        double ret= array[0];
        for (int i= 1; i < array.length; i++) {
            if (array[i] > ret)
                ret= array[i];
        }
        return ret;
    }
    
    public static int sumPA(int p1,int pn, int qtd){
    	return (int)((p1+pn)*(qtd/2D));
    	
    }

    public static int[] arraySubSet(int[] array, int from, int to) {

        if ((array == null) || ((array.length - 1) < from) || (from > to))
            return null;

        to= ((array.length - 1) < to) ? (array.length - 1) : to;

        int[] ret= new int[to - from + 1];
        for (int i= 0; i < ret.length; i++) {
            ret[i]= array[i + from];
        }
        return ret;
    }

    public static int getMinIndex(double[] array) {
        if (array == null)
            return 0;

        int ret= 0;
        for (int i= 1; i < array.length; i++) {
            if (array[i] < array[ret])
                ret= i;
        }
        return ret;
    }

    public static double getMin(double[] array) {
        if (array == null)
            return 0;

        double ret= array[0];
        for (int i= 1; i < array.length; i++) {
            if (array[i] < ret)
                ret= array[i];
        }
        return ret;
    }

    public static double getSum(double[] array) {
        if (array == null)
            return 0;

        double ret= 0;
        for (int i= 0; i < array.length; i++) {
            ret += array[i];
        }
        return ret;
    }

    public static int getMax(int[] array) {
        if (array == null)
            return 0;

        int ret= array[0];
        for (int i= 1; i < array.length; i++) {
            if (array[i] > ret)
                ret= array[i];
        }
        return ret;
    }

    public static int getMin(int[] array) {
        if (array == null)
            return 0;

        int ret= array[0];
        for (int i= 1; i < array.length; i++) {
            if (array[i] < ret)
                ret= array[i];
        }
        return ret;
    }

    public static double roundToPrecision(double in, double precision) {

        double result= ((int) (in / precision)) * precision;
        double lost= in - result;

        double out=
            (Math.abs(lost) > (precision / 2))
                ? ((lost > 0) ? result + precision : result - precision)
                : result;

        return out;

    }

    public static int getSum(int[] array) {
        if (array == null)
            return 0;

        int ret= 0;
        for (int i= 0; i < array.length; i++) {
            ret += array[i];
        }
        return ret;
    }

    // normalAbsoluteAngle is not used in this robot,
    // but is here for reference.
    /**
     * normalAbsoluteAngle:  returns angle between 0-360
     */
    public static double normalAbsoluteAngle(double angle) {
        if (angle >= 0 && angle < 360)
            return angle;
        double fixedAngle= angle;
        while (fixedAngle < 0)
            fixedAngle += 360;
        while (fixedAngle >= 360)
            fixedAngle -= 360;
        return fixedAngle;
    }

    /**
     * normalRelativeAngle:  returns angle between (-180)-(180)
     */
    public static double normalRelativeAngle(double angle) {
        if (angle > -180 && angle <= 180)
            return angle;
        double fixedAngle= angle;
        while (fixedAngle <= -180)
            fixedAngle += 360;
        while (fixedAngle > 180)
            fixedAngle -= 360;
        return fixedAngle;
    }

    /** retorna o ponto de interseccao das duas linhas. se nao intercepta, retorna null.
     */
    public static Point2D.Double lineIntersectsLine(
        Line2D.Double l1,
        Line2D.Double l2) {
        //HataMoto.getIt().out.println("lineIntersectsLine");
        if (!l1.intersectsLine(l2))
            return null;

        Point2D p11= l1.getP1();
        Point2D p12= l1.getP2();
        Point2D p21= l2.getP1();
        Point2D p22= l2.getP2();

        //HataMoto.getIt().out.println("lineIntersectsLine:P11 "+p11+", p12"+p12+", p21"+p21+", p22"+p22);

        double a1= (p12.getY() - p11.getY()) / (p12.getX() - p11.getX());
        //if(Double.isNaN(a1) ||Double.isInfinite(a1)) a1=0;
        double b1= p11.getY() - a1 * p11.getX();

        double a2= (p22.getY() - p21.getY()) / (p22.getX() - p21.getX());
        //if(Double.isNaN(a2) ||Double.isInfinite(a2)) a2=0;
        double b2= p21.getY() - a2 * p21.getX();

        //HataMoto.getIt().out.println("lineIntersectsLine:a1 "+a1+", b1 "+b1+", a2 "+a2+", b2 "+b2);

        double y;
        double x;

        if (Double.isNaN(a1) || Double.isInfinite(a1)) {
            x= p11.getX();
            //y = (x - b2)/a2;
            //y = p11.getY();
            y= a2 * x + b2;
        } else if (Double.isNaN(a2) || Double.isInfinite(a2)) {
            x= p21.getX();
            //y = (x - b1)/a1;

            //y = p21.getY();
            y= a1 * x + b1;
        } else {
            x= (b2 - b1) / (a1 - a2);
            y= a1 * x + b1;
        }

        //HataMoto.getIt().out.println("lineIntersectsLine:"+x+","+y);
        return new Point2D.Double(x, y);

    }

}
