package dft.inject.util;
import robocode.*;
import java.awt.*;
import java.awt.geom.*;

public class Utils {
	
		public static double absoluteBearing(Point2D source, Point2D target) {
			 return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
		}	
		public static double absoluteBearing(double x1, double y1, double x2, double y2) {
			return Math.atan2(x2 - x1, y2 - y1);
		}
		public static Point2D project(Point2D location, double angle, double distance) {
			return new Point2D.Double(location.getX() + Math.sin(angle) * distance, location.getY() + Math.cos(angle) * distance);
		}
		public static double findDistance(Point2D source, Point2D target) {
			return Point2D.distance(source.getX(),source.getY(),target.getX(),target.getY());
		}
		public static int distanceToTime(double distance, double velocity) {
			return (int)((distance-velocity)/velocity);
		}
		public static double findDistance(double x1, double y1, double x2, double y2) {
			return Point2D.distance(x1,y1,x2,y2);
		}	
		public static double findGF(double startAngle, double newAngle, double escapeEnvelope, double middleFactor) {			
			return (int)minMax(1,middleFactor*2-1,Math.round((1+robocode.util.Utils.normalRelativeAngle(newAngle-startAngle)/escapeEnvelope)*middleFactor));
		}
		public static double findAngle(double startAngle, double escapeEnvelope, double currentGF, double middleFactor) {
			return robocode.util.Utils.normalRelativeAngle(startAngle+escapeEnvelope*(currentGF/middleFactor-1));
		}			
		public static double minMax(double min, double max, double value) {
			if (value > max)
				return max;
			else if (value < min)
				return min;
			else 
				return value;
		}
		public static double smoothed(int gf, double[] curr, int TOTAL_FACTORS) {
			double x = 0;
			for (int y = 1; y < TOTAL_FACTORS-1; y++) {
				x += (double)curr[y]/ Math.sqrt((double)(Math.abs(gf - y) + 1.0));
			}
			return x;
	}

}