package dam.targetting;

import java.util.*;


import dam.util.*;

/**
* This is intended to figure out where to shoot when the target is
* oscillating
*/
public class PatternTargetting extends TargettingStrategy
{	
	public static double OPTIMUM_COUNT = 3;
	public boolean locked = false;
	
	public PatternTargetting()
	{
		setHeld(true);
	}
	
	/**
	 * PatternTargetting is locked once the pattern buffer has started to
	 * be able to pick off the target. Thereafter it remains locked.
	 * Locked means "locked on to target".
	 */
	public boolean isLocked(){
		return locked;
	}
	/**
	* Note that I will not fire unless I get a match. Also note that
	* all the calculation takes place in the PatternBuffer, not here.
	*/
	public void guess(long when)
	{
		PatternBuffer pb = target.getPatternBuffer();
		int diff = (int)(when - target.getLastScanTime());
		int start = pb.getPeriodRelative(diff);
		if(start != -1)
		{
			GridPoint g = pb.getPredictedPosition( start, diff, target.getHeading(), 
				target.x, target.y, target.getVelocity());
			if(g != null)
			{
				// new innovation
				if(pb.getMinCount() < OPTIMUM_COUNT){
					setPoint(g.x, g.y);
					setHeld(false);
					locked = true;
					return;
				}
			}
		}
		setHeld(true);
	}
	
			
}

