/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.gfws;

import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import xander.core.Resources;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentWaveListener;
import xander.core.math.LinearEquation;
import xander.core.track.GunStats;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.XBulletWave;
import xander.gfws.data.AgeRollFunction;
import xander.gfws.data.AgeRollLinearFunction;
import xander.gfws.data.AgeRollSquaredFunction;
import xander.gfws.data.AgeRollVariableDecaySquaredFunction;
import xander.gfws.data.FactorArrayParms;

public class AutoVaryWeightByAge
implements OpponentWaveListener,
MyWaveListener {
    private FactorArrayParms parms;
    private double noRollHitRatio;
    private LinearEquation rollEquation;
    private LinearEquation minWeightEquation;
    private GunStats gunStats;
    private int activationRound = 0;
    private RollType rollType;
    private AgeRollFunction ageRollFunction;

    public AutoVaryWeightByAge(FactorArrayParms parms, double noRollHitRatio, double lowRollHitRatio, double lowRollRate, double highRollHitRatio, double highRollRate, RollType rollType) {
        this.parms = parms;
        this.rollType = rollType;
        this.noRollHitRatio = noRollHitRatio;
        this.rollEquation = new LinearEquation(lowRollHitRatio, lowRollRate, highRollHitRatio, highRollRate, lowRollRate, highRollRate);
        this.gunStats = Resources.getGunStats();
        if (rollType == RollType.LINEAR) {
            this.ageRollFunction = new AgeRollLinearFunction(0.0);
        } else if (rollType == RollType.SQUARED) {
            this.ageRollFunction = new AgeRollSquaredFunction(1000L);
        } else if (rollType == RollType.VD_SQUARED) {
            this.ageRollFunction = new AgeRollVariableDecaySquaredFunction();
        }
        if (parms.isOffensive()) {
            Resources.getWaveHistory().addMyWaveListener(this);
        } else {
            Resources.getWaveHistory().addOpponentWaveListener(this);
        }
    }

    public void setVaryMinWeight(double lowHRDiff, double lowHRDiffMinWeight, double highHRDiff, double highHRDiffMinWeight) {
        double minY = Math.min(lowHRDiffMinWeight, highHRDiffMinWeight);
        double maxY = Math.max(lowHRDiffMinWeight, highHRDiffMinWeight);
        this.minWeightEquation = new LinearEquation(lowHRDiff, lowHRDiffMinWeight, highHRDiff, highHRDiffMinWeight, minY, maxY);
    }

    public void setActivationRound(int activationRound) {
        this.activationRound = activationRound;
    }

    private void setAgeRoll(double rollValue) {
        if (rollValue <= 0.0) {
            this.parms.setVaryWeightByAgeFunction(null);
        } else {
            if (this.parms.getVaryWeightByAgeFunction() == null) {
                this.parms.setVaryWeightByAgeFunction(this.ageRollFunction);
            }
            if (this.rollType == RollType.LINEAR) {
                ((AgeRollLinearFunction)this.ageRollFunction).setDecayPerTick(rollValue);
            } else if (this.rollType == RollType.SQUARED) {
                ((AgeRollSquaredFunction)this.ageRollFunction).setDropOffAge(Math.round(rollValue));
            } else if (this.rollType == RollType.VD_SQUARED) {
                ((AgeRollVariableDecaySquaredFunction)this.ageRollFunction).setTimeMultiplier(rollValue);
            }
        }
    }

    @Override
    public void oppWaveCreated(Wave wave) {
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet oppBullet) {
    }

    @Override
    public void oppWaveHit(Wave wave) {
        if (Resources.getRobotProxy().getRoundNum() >= this.activationRound) {
            double oppHitRatio = this.gunStats.getOverallOpponentHitRatio();
            if (oppHitRatio <= this.noRollHitRatio) {
                this.setAgeRoll(0.0);
            } else {
                this.setAgeRoll(this.rollEquation.getY(oppHitRatio));
                if (this.minWeightEquation != null) {
                    double myHitRatio = this.gunStats.getOverallHitRatio();
                    double hrDiff = myHitRatio - oppHitRatio;
                    this.parms.setMinAgeWeightPercent(this.minWeightEquation.getY(hrDiff));
                }
            }
        }
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
    }

    @Override
    public void myWaveCreated(XBulletWave wave) {
    }

    @Override
    public void myWaveHitBullet(XBulletWave wave, Bullet myBullet) {
    }

    @Override
    public void myWaveHit(XBulletWave wave, Snapshot opponentSnapshot) {
        if (Resources.getRobotProxy().getRoundNum() >= this.activationRound) {
            double myHitRatio = this.gunStats.getOverallHitRatio();
            if (myHitRatio >= this.noRollHitRatio) {
                this.setAgeRoll(0.0);
            } else {
                this.setAgeRoll(this.rollEquation.getY(myHitRatio));
            }
        }
    }

    @Override
    public void myBulletHit(XBulletWave wave, BulletHitEvent bulletHitEvent) {
    }

    @Override
    public void myWavePassing(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWavePassed(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWaveDestroyed(XBulletWave wave) {
    }

    public static enum RollType {
        LINEAR,
        SQUARED,
        VD_SQUARED;

    }
}

