/*
 * Decompiled with CFR 0.152.
 */
package xander.core.math;

import xander.core.math.Function;

public class LinearEquation
implements Function {
    private Double slope;
    private double b;
    private Double minimumY;
    private Double maximumY;

    public static double[] getIntersection(LinearEquation le1, LinearEquation le2) {
        if (le1.slope == null || le2.slope == null) {
            if (le1.slope == null && le2.slope == null) {
                return null;
            }
            double x = le1.slope == null ? le1.b : le2.b;
            double y = le1.slope == null ? le2.getY(x) : le1.getY(x);
            return new double[]{x, y};
        }
        if (le1.slope.equals(le2.slope)) {
            return null;
        }
        double x = (le2.b - le1.b) / (le1.slope - le2.slope);
        double y = le1.getY(x);
        return new double[]{x, y};
    }

    public LinearEquation(double x1, double y1, double x2, double y2) {
        if (x2 != x1) {
            this.slope = new Double((y2 - y1) / (x2 - x1));
            this.b = y1 - this.slope * x1;
        } else {
            this.b = x1;
        }
    }

    public LinearEquation(double x1, double y1, double x2, double y2, double minimumY, double maximumY) {
        this(x1, y1, x2, y2);
        this.minimumY = new Double(minimumY);
        this.maximumY = new Double(maximumY);
    }

    public LinearEquation(Double slope, double b) {
        this.slope = slope;
        this.b = b;
    }

    @Override
    public double getY(double x) {
        if (this.slope == null) {
            return Double.NaN;
        }
        double y = this.slope * x + this.b;
        if (this.minimumY != null && this.minimumY > y) {
            return this.minimumY;
        }
        if (this.maximumY != null && this.maximumY < y) {
            return this.maximumY;
        }
        return y;
    }

    public double getX(double y) {
        if (this.slope == null) {
            return this.b;
        }
        if (this.slope == 0.0) {
            return Double.NaN;
        }
        return (y - this.b) / this.slope;
    }

    public Double getSlope() {
        return this.slope;
    }

    public double getB() {
        return this.b;
    }

    public Double getMinimumY() {
        return this.minimumY;
    }

    public Double getMaximumY() {
        return this.maximumY;
    }

    public LinearEquation getPerpendicularThroughPoint(double x, double y) {
        Double newSlope = null;
        if (this.slope == null) {
            newSlope = new Double(0.0);
        } else if (this.slope != null && this.slope != 0.0) {
            newSlope = new Double(-1.0 / this.slope);
        }
        double newB = newSlope == null ? x : y - newSlope * x;
        return new LinearEquation(newSlope, newB);
    }
}

