/*
 * Decompiled with CFR 0.152.
 */
package jdw.hurricane.engine;

import jdw.hurricane.Enemy;
import jdw.hurricane.GlobalData;
import jdw.util.FastTrig;
import robocode.Rules;

public class Branch
extends GlobalData {
    private final int branch_ticks = 16;
    private final double c_x;
    private final double c_y;
    private final double c_rot;
    private final double c_vel;
    private final int steps_left;
    public final double steer;
    public final double targ_vel;
    private final double[][] pts;
    private final Branch[] branches;

    public Branch(int depth) {
        this(0.0, 0.0, 0.0, 8.0, new double[0][0], 0.0, 8.0, depth);
    }

    private Branch(double _c_x, double _c_y, double _c_rot, double _c_vel, double[][] _pts, double _steer, double _targ_vel, int depth) {
        this.c_x = _c_x;
        this.c_y = _c_y;
        this.c_rot = _c_rot;
        this.c_vel = _c_vel;
        this.steps_left = (depth + 1) * 16;
        this.pts = _pts;
        this.steer = _steer;
        this.targ_vel = _targ_vel;
        this.branches = depth == 0 ? new Branch[0] : this.get_branches(depth - 1);
    }

    private Branch[] get_branches(int depth) {
        return new Branch[]{this.get_branch(-1.0, -8.0, depth), this.get_branch(-1.0, -4.0, depth), this.get_branch(-1.0, 4.0, depth), this.get_branch(-1.0, 8.0, depth), this.get_branch(0.0, -8.0, depth), this.get_branch(0.0, 8.0, depth), this.get_branch(1.0, -8.0, depth), this.get_branch(1.0, -4.0, depth), this.get_branch(1.0, 4.0, depth), this.get_branch(1.0, 8.0, depth)};
    }

    private Branch get_branch(double turn, double targ_vel, int depth) {
        int i = 0;
        double new_x = this.c_x;
        double new_y = this.c_y;
        double new_rot = this.c_rot;
        double new_vel = this.c_vel;
        double[][] new_pts = new double[16][2];
        while (i < 16) {
            new_vel = this.get_next_vel(new_vel, targ_vel);
            new_pts[i][0] = new_x += FastTrig.sin(new_rot += Rules.getTurnRateRadians((double)new_vel) * turn) * new_vel;
            new_pts[i][1] = new_y += FastTrig.cos(new_rot) * new_vel;
            ++i;
        }
        return new Branch(new_x, new_y, new_rot, new_vel, new_pts, turn, targ_vel, depth);
    }

    private double get_next_vel(double cur_vel, double targ_vel) {
        if (targ_vel < 0.0) {
            return -this.get_next_vel(-cur_vel, -targ_vel);
        }
        if (cur_vel < 0.0) {
            double nextVelocity = cur_vel + 2.0;
            if (nextVelocity > 1.0) {
                nextVelocity = 1.0;
            }
            if (nextVelocity > targ_vel) {
                return targ_vel;
            }
            return nextVelocity;
        }
        if (cur_vel > targ_vel) {
            double nextVelocity = cur_vel - 2.0;
            if (nextVelocity < targ_vel) {
                return targ_vel;
            }
            return nextVelocity;
        }
        double nextVelocity = cur_vel + 1.0;
        if (nextVelocity > targ_vel) {
            return targ_vel;
        }
        return nextVelocity;
    }

    public double[] get_best_branch(double x, double y, double rot, double vel) {
        boolean flip;
        boolean bl = flip = vel > -8.01 && vel < -7.99;
        if (flip) {
            rot += Math.PI;
            vel = 8.0;
        } else if (!(vel < 7.99)) {
            // empty if block
        }
        double sin_rot = Math.sin(rot);
        double cos_rot = Math.cos(rot);
        Branch best = null;
        double best_grav = Double.NEGATIVE_INFINITY;
        int i = this.branches.length;
        while (i-- != 0) {
            double grav = this.branches[i].get_grav(sin_rot, cos_rot, x, y);
            if (!(grav > best_grav)) continue;
            best = this.branches[i];
            best_grav = grav;
        }
        if (best == null) {
            return null;
        }
        x = cos_rot * best.c_x + sin_rot * best.c_y + x;
        y = -sin_rot * best.c_x + cos_rot * best.c_y + y;
        painter.paint_circle(x, y, 10.0, 1.0);
        double[] res = new double[]{best.steer, best.targ_vel};
        if (flip) {
            res[1] = -res[1];
        }
        return res;
    }

    private double get_grav(double sin_rot, double cos_rot, double x_trans, double y_trans) {
        double seg_grav = 0.0;
        int i = 0;
        while (i < 16) {
            double x = cos_rot * this.pts[i][0] + sin_rot * this.pts[i][1] + x_trans;
            double y = -sin_rot * this.pts[i][0] + cos_rot * this.pts[i][1] + y_trans;
            if (x < in_min_x_y || x > in_max_x || y < in_min_x_y || y > in_max_y) {
                return Double.NEGATIVE_INFINITY;
            }
            int ticks_left = 80 + i - this.steps_left;
            double rx = pos_x_history[pos_history_i] - x;
            double ry = pos_y_history[pos_history_i] - y;
            seg_grav -= 20.0 * (double)num_enemies_alive / (rx * rx + ry * ry + 100.0);
            int j = 0;
            while (j < num_enemies_alive) {
                Enemy e = sorted_enemies[j];
                if (e.active) {
                    rx = e.x - x;
                    ry = e.y - y;
                    double d = rx * rx + ry * ry;
                    if (e.last_energy > 0.05) {
                        seg_grav -= 100.0 * (double)ticks_left / d;
                    } else {
                        if (d < 1296.0) {
                            return seg_grav + 50.0 * (double)(this.steps_left - i);
                        }
                        seg_grav += 500.0 * (double)ticks_left / d;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = this.branches.length;
        if (i == 0) {
            return seg_grav;
        }
        double max_grav = Double.NEGATIVE_INFINITY;
        while (i-- != 0) {
            double grav = this.branches[i].get_grav(sin_rot, cos_rot, x_trans, y_trans);
            if (!(grav > max_grav)) continue;
            max_grav = grav;
        }
        return seg_grav + max_grav;
    }
}

