/*
 * Decompiled with CFR 0.152.
 */
package jdw.hurricane.gun;

import java.util.Arrays;
import jdw.hurricane.Enemy;
import jdw.hurricane.gun.LinkedRobotState;
import jdw.util.KdTree;

public class EnemyData
extends KdTree.WeightedSqrEuclid<LinkedRobotState> {
    private Enemy enemy;
    public int dims;
    private int stage = 0;
    private LinkedRobotState cursor;
    private int count;
    private double[] means;
    private double[][] covars;

    public EnemyData(Enemy _enemy, int _dims) {
        super(_dims, 10000);
        this.enemy = _enemy;
        this.dims = _dims;
    }

    public void calc_weights() {
        int i = 0;
        switch (this.stage) {
            case 0: {
                int j;
                this.means = new double[this.dims];
                while (this.cursor != null) {
                    j = 0;
                    while (j < this.dims) {
                        int n = j;
                        this.means[n] = this.means[n] + this.cursor.point[j];
                        ++j;
                    }
                    this.cursor = this.cursor.prev;
                    ++i;
                }
                j = 0;
                while (j < this.dims) {
                    int n = j++;
                    this.means[n] = this.means[n] / (double)i;
                }
                this.stage = 1;
                break;
            }
            case 1: {
                int k;
                int j;
                this.covars = new double[this.dims][this.dims];
                while (this.cursor != null) {
                    double[] pt = this.cursor.point;
                    j = 0;
                    while (j < this.dims) {
                        int n = j;
                        pt[n] = pt[n] - this.means[j];
                        k = 0;
                        while (k <= j) {
                            double[] dArray = this.covars[j];
                            int n2 = k;
                            dArray[n2] = dArray[n2] + pt[j] * pt[k];
                            ++k;
                        }
                        ++j;
                    }
                    this.cursor = this.cursor.prev;
                    ++i;
                }
                j = 0;
                while (j < this.dims) {
                    this.covars[j][j] = Math.max(1.0E-12, Math.sqrt(this.covars[j][j] / (double)i));
                    k = 0;
                    while (k < j) {
                        double[] dArray = this.covars[j];
                        int n = k;
                        dArray[n] = dArray[n] / ((double)i * this.covars[j][j] * this.covars[k][k]);
                        ++k;
                    }
                    System.out.println(Arrays.toString(this.covars[j]));
                    ++j;
                }
                this.stage = 0;
            }
        }
    }
}

