/*
 * Decompiled with CFR 0.152.
 */
package GarmBox;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class Oranges
extends TeamRobot {
    int deaths = 0;
    boolean last = false;
    double lastEnergy = 100.0;

    public void run() {
        if (this.getRoundNum() > 0) {
            try {
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(this.getDataFile("data.dat")));
                    this.deaths = Integer.parseInt(bufferedReader.readLine());
                    this.last = Integer.parseInt(bufferedReader.readLine()) == this.getRoundNum();
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (NumberFormatException numberFormatException) {}
        }
        System.out.println(this.deaths);
        this.setColors(new Color(184, 8, 132), new Color(81, 16, 206), new Color(150, 4, 0));
        this.setBulletColor(new Color(42, 255, 0));
        this.setScanColor(new Color(156, 255, 0));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.scan();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        if (this.isTeammate(scannedRobotEvent.getName())) {
            return;
        }
        double d = this.getHeadingRadians() + scannedRobotEvent.getBearingRadians() - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(1.9 * Utils.normalRelativeAngle((double)d));
        if (scannedRobotEvent.getEnergy() != this.lastEnergy) {
            this.setAhead(60.0);
            this.setTurnLeft(40.0);
        } else {
            double d2 = this.getHeadingRadians() + scannedRobotEvent.getBearingRadians() - this.getGunHeadingRadians();
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)d2));
            int n = this.getEnergy() > 30.0 ? 3 : 2;
            this.setFire(n);
            if (Math.random() > 0.6) {
                this.setAhead(40.0);
            }
            if (Math.random() > 0.6) {
                if (Math.random() > 0.8) {
                    this.setTurnLeft(50.0);
                } else {
                    this.setTurnRight(50.0);
                }
            }
        }
        this.lastEnergy = scannedRobotEvent.getEnergy();
        this.execute();
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        this.setTurnRight(65.0);
        this.setAhead(90.0);
    }

    public void onDeath(DeathEvent deathEvent) {
        PrintStream printStream = null;
        try {
            try {
                printStream = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile("data.dat")));
                printStream.println(this.deaths + 1);
                printStream.println(this.getRoundNum());
            }
            catch (IOException iOException) {
                if (printStream != null) {
                    printStream.close();
                }
            }
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }
}

