/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.decomposition.AbstractDecompositor;
import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.matrix.SparseMatrix;

public class RawLUDecompositor
extends AbstractDecompositor
implements MatrixDecompositor {
    public RawLUDecompositor(Matrix matrix) {
        super(matrix);
    }

    @Override
    public Matrix[] decompose() {
        Matrix lu = this.matrix.copy();
        SparseMatrix p = SparseMatrix.identity(lu.rows());
        for (int j = 0; j < lu.columns(); ++j) {
            int i;
            for (int i2 = 0; i2 < lu.rows(); ++i2) {
                int kmax = Math.min(i2, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += lu.get(i2, k) * lu.get(k, j);
                }
                lu.updateAt(i2, j, Matrices.asMinusFunction(s));
            }
            int pivot = j;
            for (i = j + 1; i < lu.rows(); ++i) {
                if (!(Math.abs(lu.get(i, j)) > Math.abs(lu.get(pivot, j)))) continue;
                pivot = i;
            }
            if (pivot != j) {
                lu.swapRows(pivot, j);
                p.swapRows(pivot, j);
            }
            if (j >= lu.rows() || !(Math.abs(lu.get(j, j)) > Matrices.EPS)) continue;
            for (i = j + 1; i < lu.rows(); ++i) {
                lu.updateAt(i, j, Matrices.asDivFunction(lu.get(j, j)));
            }
        }
        return new Matrix[]{lu, p};
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        return matrix.rows() == matrix.columns();
    }
}

