/*
 * Decompiled with CFR 0.152.
 */
package rdm.state.entities;

import java.awt.geom.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import rdm.state.entities.EnemyState;
import rdm.state.entities.SelfState;
import rdm.state.entities.WorldState;
import robocode.Rules;
import robocode.util.Utils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nJ\u001e\u0010%\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nJ\u0018\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\nH\u0002J\u0016\u0010+\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nJ\b\u0010,\u001a\u00020\nH\u0002J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J\t\u0010/\u001a\u00020\u0007H\u00c6\u0003J'\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u000205H\u00d6\u0001J \u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\n2\u0006\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\nH\u0002J\t\u0010:\u001a\u00020;H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u001b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006<"}, d2={"Lrdm/state/entities/InstantState;", "", "world", "Lrdm/state/entities/WorldState;", "self", "Lrdm/state/entities/SelfState;", "enemy", "Lrdm/state/entities/EnemyState;", "(Lrdm/state/entities/WorldState;Lrdm/state/entities/SelfState;Lrdm/state/entities/EnemyState;)V", "absoluteBearing", "", "getAbsoluteBearing", "()D", "absoluteBearingRadians", "getAbsoluteBearingRadians", "distanceToWallBehindEnemy", "getDistanceToWallBehindEnemy", "distanceToWallToLeftOfEnemy", "getDistanceToWallToLeftOfEnemy", "distanceToWallToRightOfEnemy", "getDistanceToWallToRightOfEnemy", "getEnemy", "()Lrdm/state/entities/EnemyState;", "forwardWallDistance", "getForwardWallDistance", "relativeEnemyHeading", "getRelativeEnemyHeading", "reverseWallDistance", "getReverseWallDistance", "getSelf", "()Lrdm/state/entities/SelfState;", "getWorld", "()Lrdm/state/entities/WorldState;", "calculateCircularPrediction", "bulletPower", "enemyVelocity", "enemyHeadingChange", "calculateCircularPredictionRadians", "enemyHeadingChangeRadians", "calculateDistanceToWall", "position", "Ljava/awt/geom/Point2D;", "angle", "calculateLinearPredictionRadians", "calculateRelativeEnemyHeading", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "limit", "value", "min", "max", "toString", "", "Commons"})
public final class InstantState {
    private final double absoluteBearing;
    private final double absoluteBearingRadians;
    private final double relativeEnemyHeading;
    private final double distanceToWallBehindEnemy;
    private final double distanceToWallToLeftOfEnemy;
    private final double distanceToWallToRightOfEnemy;
    private final double forwardWallDistance;
    private final double reverseWallDistance;
    @NotNull
    private final WorldState world;
    @NotNull
    private final SelfState self;
    @NotNull
    private final EnemyState enemy;

    public final double getAbsoluteBearing() {
        return this.absoluteBearing;
    }

    public final double getAbsoluteBearingRadians() {
        return this.absoluteBearingRadians;
    }

    public final double getRelativeEnemyHeading() {
        return this.relativeEnemyHeading;
    }

    public final double getDistanceToWallBehindEnemy() {
        return this.distanceToWallBehindEnemy;
    }

    public final double getDistanceToWallToLeftOfEnemy() {
        return this.distanceToWallToLeftOfEnemy;
    }

    public final double getDistanceToWallToRightOfEnemy() {
        return this.distanceToWallToRightOfEnemy;
    }

    public final double getForwardWallDistance() {
        return this.forwardWallDistance;
    }

    public final double getReverseWallDistance() {
        return this.reverseWallDistance;
    }

    public final double calculateLinearPredictionRadians(double bulletPower, double enemyVelocity) {
        double d;
        double c;
        double a;
        double D;
        double C;
        double ROBOT_WIDTH = 16.0;
        double ROBOT_HEIGHT = 16.0;
        double eAbsBearing = this.self.getBody().getHeadingRadians() + this.enemy.getBearingRadians();
        double rX = this.self.getBody().getPosition().getX();
        double rY = this.self.getBody().getPosition().getY();
        double bV = Rules.getBulletSpeed((double)bulletPower);
        double eX = rX + this.enemy.getDistance() * Math.sin(eAbsBearing);
        double eY = rY + this.enemy.getDistance() * Math.cos(eAbsBearing);
        double A = (eX - rX) / bV;
        double eV = enemyVelocity;
        double eHd = this.enemy.getHeadingRadians();
        double B = eV / bV * Math.sin(eHd);
        double b = (double)2 * (A * B + (C = (eY - rY) / bV) * (D = eV / bV * Math.cos(eHd)));
        double discriminant = b * b - 4.0 * (a = A * A + C * C) * (c = B * B + D * D - 1.0);
        if (discriminant >= 0.0) {
            double t2;
            double t1 = (double)2 * a / (-b - Math.sqrt(discriminant));
            double t = Math.min(t1, t2 = (double)2 * a / (-b + Math.sqrt(discriminant))) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2);
            double endX = this.limit(eX + eV * t * Math.sin(eHd), ROBOT_WIDTH / (double)2, this.world.getWidth() - ROBOT_WIDTH / (double)2);
            double endY = this.limit(eY + eV * t * Math.cos(eHd), ROBOT_HEIGHT / (double)2, this.world.getHeight() - ROBOT_HEIGHT / (double)2);
            d = Utils.normalRelativeAngle((double)Math.atan2(endX - rX, endY - rY));
        } else {
            d = 0.0;
        }
        return d;
    }

    public final double calculateCircularPrediction(double bulletPower, double enemyVelocity, double enemyHeadingChange) {
        return Math.toDegrees(this.calculateCircularPredictionRadians(bulletPower, enemyVelocity, Math.toRadians(enemyHeadingChange)));
    }

    public final double calculateCircularPredictionRadians(double bulletPower, double enemyVelocity, double enemyHeadingChangeRadians) {
        double myX = this.self.getBody().getPosition().getX();
        double myY = this.self.getBody().getPosition().getY();
        double halfBodySize = this.self.getBody().getSize() / (double)2;
        double absoluteBearing = this.self.getBody().getHeadingRadians() + this.enemy.getBearingRadians();
        double enemyX = myX + this.enemy.getDistance() * Math.sin(absoluteBearing);
        double enemyY = myY + this.enemy.getDistance() * Math.cos(absoluteBearing);
        double enemyHeading = this.enemy.getHeadingRadians();
        double deltaTime = 0.0;
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * Rules.getBulletSpeed((double)bulletPower) < Point2D.distance(myX, myY, predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading += enemyHeadingChangeRadians) * enemyVelocity) < halfBodySize || predictedY < halfBodySize || predictedX > this.world.getWidth() - halfBodySize) && !(predictedY > this.world.getHeight() - halfBodySize)) continue;
            predictedX = Math.min(Math.max(halfBodySize, predictedX), this.world.getWidth() - halfBodySize);
            predictedY = Math.min(Math.max(halfBodySize, predictedY), this.world.getHeight() - halfBodySize);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - myX, predictedY - myY));
        return Utils.normalRelativeAngle((double)(theta - absoluteBearing));
    }

    private final double calculateRelativeEnemyHeading() {
        return Utils.normalRelativeAngleDegrees((double)(this.enemy.getHeading() - this.absoluteBearing));
    }

    private final double limit(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    private final double calculateDistanceToWall(Point2D position, double angle) {
        double normal;
        double side;
        double x = position.getX();
        double y = position.getY();
        double topRight = Utils.normalAbsoluteAngle((double)Math.atan2(this.world.getHeight() - y, this.world.getWidth() - x));
        double topLeft = Utils.normalAbsoluteAngle((double)Math.atan2(this.world.getHeight() - y, -x));
        double bottomLeft = Utils.normalAbsoluteAngle((double)Math.atan2(-y, -x));
        double bottomRight = Utils.normalAbsoluteAngle((double)Math.atan2(-y, this.world.getWidth() - x));
        double normalAbsoluteDegrees = Utils.normalAbsoluteAngleDegrees((double)(90.0 - angle));
        double normalAbsolute = Math.toRadians(normalAbsoluteDegrees);
        double d = normalAbsolute;
        double d2 = d;
        if (d2 >= topRight && d2 <= topLeft) {
            side = this.world.getHeight() - y;
            normal = normalAbsolute - 1.5707963267948966;
        } else {
            d2 = d;
            if (d2 >= topLeft && d2 <= bottomLeft) {
                side = x;
                normal = normalAbsolute - Math.PI;
            } else {
                d2 = d;
                if (d2 >= bottomLeft && d2 <= bottomRight) {
                    side = y;
                    normal = normalAbsolute - 4.71238898038469;
                } else {
                    side = this.world.getWidth() - x;
                    normal = normalAbsolute - Math.PI * 2;
                }
            }
        }
        return side / Math.cos(normal);
    }

    @NotNull
    public final WorldState getWorld() {
        return this.world;
    }

    @NotNull
    public final SelfState getSelf() {
        return this.self;
    }

    @NotNull
    public final EnemyState getEnemy() {
        return this.enemy;
    }

    public InstantState(@NotNull WorldState world, @NotNull SelfState self, @NotNull EnemyState enemy) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(self, "self");
        Intrinsics.checkParameterIsNotNull(enemy, "enemy");
        this.world = world;
        this.self = self;
        this.enemy = enemy;
        this.absoluteBearing = this.self.getBody().getHeading() + this.enemy.getBearing();
        this.absoluteBearingRadians = this.self.getBody().getHeadingRadians() + this.enemy.getBearingRadians();
        this.relativeEnemyHeading = this.calculateRelativeEnemyHeading();
        this.distanceToWallBehindEnemy = this.calculateDistanceToWall(this.self.getBody().getPosition(), this.absoluteBearing);
        this.distanceToWallToLeftOfEnemy = this.calculateDistanceToWall(this.self.getBody().getPosition(), this.absoluteBearing - 60.0);
        this.distanceToWallToRightOfEnemy = this.calculateDistanceToWall(this.self.getBody().getPosition(), this.absoluteBearing + 60.0);
        this.forwardWallDistance = this.calculateDistanceToWall(this.enemy.getPosition(), this.enemy.getHeading());
        this.reverseWallDistance = this.calculateDistanceToWall(this.enemy.getPosition(), this.enemy.getHeading() - 180.0);
    }

    @NotNull
    public final WorldState component1() {
        return this.world;
    }

    @NotNull
    public final SelfState component2() {
        return this.self;
    }

    @NotNull
    public final EnemyState component3() {
        return this.enemy;
    }

    @NotNull
    public final InstantState copy(@NotNull WorldState world, @NotNull SelfState self, @NotNull EnemyState enemy) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(self, "self");
        Intrinsics.checkParameterIsNotNull(enemy, "enemy");
        return new InstantState(world, self, enemy);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ InstantState copy$default(InstantState instantState, WorldState worldState, SelfState selfState, EnemyState enemyState, int n, Object object) {
        if ((n & 1) != 0) {
            worldState = instantState.world;
        }
        if ((n & 2) != 0) {
            selfState = instantState.self;
        }
        if ((n & 4) != 0) {
            enemyState = instantState.enemy;
        }
        return instantState.copy(worldState, selfState, enemyState);
    }

    public String toString() {
        return "InstantState(world=" + this.world + ", self=" + this.self + ", enemy=" + this.enemy + ")";
    }

    public int hashCode() {
        WorldState worldState = this.world;
        SelfState selfState = this.self;
        EnemyState enemyState = this.enemy;
        return ((worldState != null ? ((Object)worldState).hashCode() : 0) * 31 + (selfState != null ? ((Object)selfState).hashCode() : 0)) * 31 + (enemyState != null ? ((Object)enemyState).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof InstantState)) break block3;
                InstantState instantState = (InstantState)object;
                if (!Intrinsics.areEqual(this.world, instantState.world) || !Intrinsics.areEqual(this.self, instantState.self) || !Intrinsics.areEqual(this.enemy, instantState.enemy)) break block3;
            }
            return true;
        }
        return false;
    }
}

