/*
 * Decompiled with CFR 0.152.
 */
package amk.guns;

import amk.util.Gun;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Segment
extends Gun {
    static int n;
    static double[] ev;
    static StringBuffer pattern;
    String name = "Disjointed";
    String version = "0.1";
    private static final double MAX_STAND_OFF_DISTANCE = 600.0;
    private static final double MIN_STAND_OFF_DISTANCE = 500.0;
    private static final double GUESS_FACTORS = 23.0;
    private static final double MIDDLE_FACTOR = 11.0;
    private static final double WALL_CURVE_DISTANCE = 180.0;
    private static final int CLOSE_IN = -1;
    private static final int BACK_OFF = 1;
    private static Rectangle2D.Double field;
    private static int[][][][][][] statBuffer;
    private static String targetName;
    private static int hits;
    private int direction = 1;
    private int eDirection = 0;
    private double eEnergy = 100.0;
    private double eX;
    private double eY;
    private double eDelta;
    private double eAbsBearing;
    private double eVelocity;
    private double eDistance;
    private double eHeading;
    private boolean flatten = hits > 2;
    private double eLastShot = 3.0;
    private static int ticksSinceReverse;
    int lastLatVelIndex = 0;

    public Segment(AdvancedRobot bot) {
        master = bot;
        field = new Rectangle2D.Double(18.0, 18.0, master.getBattleFieldWidth() - 36.0, master.getBattleFieldHeight() - 36.0);
    }

    public void prepare(ScannedRobotEvent e) {
        double d;
        double d2;
        targetName = e.getName();
        this.eHeading = e.getHeadingRadians();
        this.eDistance = e.getDistance();
        this.eAbsBearing = Utils.normalRelativeAngle((double)(master.getHeadingRadians() + e.getBearingRadians()));
        this.eVelocity = e.getVelocity();
        if (Math.abs(this.eVelocity) > Math.abs(d2)) {
            ticksSinceReverse = 0;
        }
        double latVel = this.eVelocity * Math.sin(this.eHeading - this.eAbsBearing);
        this.eX = master.getX() + Math.sin(this.eAbsBearing) * this.eDistance;
        this.eY = master.getY() + Math.cos(this.eAbsBearing) * this.eDistance;
        if (latVel != 0.0) {
            this.eDirection = (int)(Math.abs(latVel) / latVel);
        }
        int distanceIndex = (int)Math.min(4.0, this.eDistance / 180.0);
        this.eEnergy = e.getEnergy();
        this.eDelta = this.eEnergy - this.eEnergy;
        if (d > 0.0 && this.eDelta <= 3.0) {
            this.eLastShot = this.eDelta;
        }
        double firePower = distanceIndex <= 1 ? 3.0 : 1.9;
        double distDelta = 1.5907963267948966 + (e.getDistance() > 400.0 ? -0.1 : 0.5);
        double theta = 0.5952 * this.bulletV(this.eLastShot) / this.eDistance;
        if (Math.random() > Math.pow(theta, theta) && this.flatten || distDelta < 0.7853981633974483 || distDelta < 1.0471975511965976 && this.eDistance < 400.0) {
            this.direction = -this.direction;
        }
        if (statBuffer == null) {
            statBuffer = (int[][][][][][])this.readObject(targetName);
        }
        this.lastLatVelIndex = (int)Math.abs(latVel) / 2;
        int[] stats = statBuffer[this.getOutIndex()][this.lastLatVelIndex][this.lastLatVelIndex][Math.min(4, ++ticksSinceReverse / 10)][distanceIndex];
        int bestIndex = 11;
        for (int i = 0; i < stats.length; ++i) {
            if (stats[i] <= stats[bestIndex]) continue;
            bestIndex = i;
        }
        master.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.eAbsBearing - master.getGunHeadingRadians() + this.getGuessAngle(bestIndex, firePower))));
        if (firePower > 0.0) {
            Wave w = new Wave();
            w.guessFactors = stats;
            w.wDirection = this.eDirection;
            w.bulletVel = this.bulletV(firePower);
            w.dist += w.bulletVel;
            w.shotOrigin = new Point2D.Double(master.getX(), master.getY());
            w.startingAbsTargetBearing = this.eAbsBearing;
            w.maxAnglePossible = Math.asin(8.0 / w.bulletVel);
            master.addCustomEvent((Condition)w);
        }
    }

    private double bulletV(double shotPower) {
        return 20.0 - 3.0 * shotPower;
    }

    Object readObject(String fileName) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(master.getDataFile(fileName))));
            Object o = ois.readObject();
            ois.close();
            return o;
        }
        catch (Exception e) {
            return new int[5][5][5][5][5][23];
        }
    }

    private double getGuessAngle(int guessIndex, double firePower) {
        if (this.eEnergy == 0.0) {
            return 0.0;
        }
        return ((double)guessIndex - 11.0) / 11.0 * Math.asin(8.0 / this.bulletV(firePower)) * (double)this.eDirection;
    }

    private int getOutIndex() {
        int i = 0;
        while (++i < 4 && field.contains(this.eX + Math.sin(this.eHeading) * (45.0 * (double)i) * (double)this.eDirection, this.eY + Math.cos(this.eHeading) * (45.0 * (double)i) * (double)this.eDirection)) {
        }
        return i;
    }

    public void onWin(WinEvent e) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(master.getDataFile(targetName))));
            oos.writeObject(statBuffer);
            oos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        ev = new double[100000];
        pattern = new StringBuffer();
        ticksSinceReverse = 0;
    }

    public class Wave
    extends Condition {
        public Point2D.Double shotOrigin;
        public double bulletVel;
        public double dist;
        public double startingAbsTargetBearing;
        public double maxAnglePossible;
        public int[] guessFactors;
        public int wDirection;

        public boolean test() {
            double d;
            this.dist += this.bulletVel;
            if (d >= this.shotOrigin.distance(Segment.this.eX, Segment.this.eY) - 18.0) {
                double currentAbsBearingFromShotOrigin = Math.atan2(Segment.this.eX - this.shotOrigin.getX(), Segment.this.eY - this.shotOrigin.getY());
                int n = (int)Math.max(0.0, Math.min(22.0, (double)((int)Math.round(Utils.normalRelativeAngle((double)(currentAbsBearingFromShotOrigin - this.startingAbsTargetBearing)) * (double)this.wDirection / this.maxAnglePossible * 11.0 + 11.0))));
                this.guessFactors[n] = this.guessFactors[n] + 1;
                Gun.master.removeCustomEvent((Condition)this);
            }
            return false;
        }
    }
}

