/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.DrawingBot;
import Krabb.sliNk.Garm;
import Krabb.sliNk.Stats;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.util.Utils;

final class DataHandling {
    private static final double BOTWIDTH_HALF = 18.0;
    private static DrawingBot bot;

    DataHandling() {
    }

    public static void init(DrawingBot robot) {
        bot = robot;
    }

    public static double wallDistance(Point2D.Double object, double heading, double velocity) {
        double distance = 999999.0;
        if ((heading = Utils.normalRelativeAngle((double)heading)) < 0.0 && heading > -Math.PI) {
            distance = Math.min(distance, Math.abs((object.getX() - 18.0) / Math.sin(heading) * Math.signum(velocity)));
        }
        if (heading < 1.5707963267948966 && heading > -1.5707963267948966) {
            distance = Math.min(distance, Math.abs((Garm.field_rect_inner.height + 18.0 - object.getY()) / Math.cos(heading) * Math.signum(velocity)));
        }
        if (heading > 0.0 && heading < Math.PI) {
            distance = Math.min(distance, Math.abs((Garm.field_rect_inner.width + 18.0 - object.getX()) / Math.sin(heading) * Math.signum(velocity)));
        }
        if (heading > 1.5707963267948966 || heading < -1.5707963267948966) {
            distance = Math.min(distance, Math.abs((object.getY() - 18.0) / Math.cos(heading) * Math.signum(velocity)));
        }
        return distance;
    }

    public static double wallDistance(Point2D.Double object) {
        double distance = 999999.0;
        distance = Math.min(distance, object.getX() - 18.0);
        distance = Math.min(distance, object.getY() - 18.0);
        distance = Math.min(distance, Garm.field_rect_inner.width - object.getX() - 18.0);
        distance = Math.min(distance, Garm.field_rect_inner.height - object.getY() - 18.0);
        return distance;
    }

    public static double lateralVelocity(Stats stats_source, Stats stats_object) {
        return stats_object.velocity * Math.sin(stats_object.heading - DataHandling.absoluteAngle(stats_source.location, stats_object.location));
    }

    public static double absoluteAngle(Point2D.Double origin, Point2D.Double destination) {
        return Math.atan2(destination.x - origin.x, destination.y - origin.y);
    }

    public static double getAngle(Point2D.Double origin, Point2D.Double destination) {
        return Math.atan2(destination.x - origin.x, destination.y - origin.y);
    }

    public static double getDistance(Point2D.Double origin, Point2D.Double destination) {
        return Math.sqrt(Math.pow(destination.x - origin.x, 2.0) + Math.pow(destination.y - origin.y, 2.0));
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double mySignum(double value) {
        if (value == 0.0) {
            return 1.0;
        }
        return Math.signum(value);
    }

    static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    static int movedirection_angular(Stats source, Stats object) {
        Point2D.Double new_object_location = DataHandling.project(object.location, object.heading_last, object.velocity_nonenull);
        return DataHandling.movedirection_angular(source.location, object.location, new_object_location);
    }

    static double getGauss(double x, double m, double s) {
        double xms = (x - m) / s;
        return 1.0 / (s * Math.sqrt(Math.PI * 2)) * Math.pow(Math.E, -0.5 * xms * xms);
    }

    static int movedirection_angular(Point2D.Double source, Point2D.Double object_old, Point2D.Double object_new) {
        double alpha_old = DataHandling.absoluteAngle(source, object_old);
        double alpha_new = DataHandling.absoluteAngle(source, object_new);
        return (int)DataHandling.mySignum(Utils.normalRelativeAngle((double)(alpha_new - alpha_old)));
    }

    public static int getBin(double gf, int bins_number) {
        int bin = (int)Math.round(Math.min(Math.max(((gf + 1.0) * (double)bins_number - 1.0) / 2.0, 0.0), (double)(bins_number - 1)));
        return Math.min(Math.max(bin, 0), bins_number - 1);
    }

    public static double convertBin2GF(int bin, int bins_number) {
        return (2.0 * (double)bin - (double)bins_number + 1.0) / (double)bins_number;
    }

    public static double getDamage(double power) {
        return 4.0 * power + 2.0 * Math.max(power - 1.0, 0.0);
    }

    public static double getEnergyGain(double power) {
        return 3.0 * power;
    }

    public static double getWallHitDamage(double velocity) {
        return Math.max(Math.abs(velocity) / 2.0 - 1.0, 0.0);
    }

    public static int getMaxIndex(double[] values) {
        return DataHandling.getMaxIndex(values, values[0] - 1.0, 0, values.length - 1);
    }

    public static int getMaxIndex(double[] values, double best, int start, int end) {
        double value_best = best;
        int index_best = -1;
        int i = start;
        while (i <= end) {
            if (values[i] > value_best) {
                value_best = values[i];
                index_best = i;
            }
            ++i;
        }
        return index_best;
    }

    public static boolean setHitEdgeBearing(double wave_radius, Point2D.Double victim, Stats stats_source, double gf_null_angle, double bullet_velocity, double[] bearings, boolean hit) {
        double[] ex = new double[4];
        double[] ey = new double[4];
        ex[0] = victim.getX() - 18.0;
        ey[0] = victim.getY() - 18.0;
        ex[1] = victim.getX() + 18.0;
        ey[1] = victim.getY() + 18.0;
        ex[2] = victim.getX() - 18.0;
        ey[2] = victim.getY() + 18.0;
        ex[3] = victim.getX() + 18.0;
        ey[3] = victim.getY() - 18.0;
        int edge = 0;
        while (edge < 4) {
            double y_delta;
            double x_delta = ex[edge] - stats_source.getX();
            double distance = Math.sqrt(x_delta * x_delta + (y_delta = ey[edge] - stats_source.getY()) * y_delta);
            if (distance < wave_radius && distance > wave_radius - bullet_velocity) {
                double bearing = Math.atan2(x_delta, y_delta);
                DataHandling.updateMinMaxHitBearing(bearing, gf_null_angle, bearings, hit);
                hit = true;
            }
            ++edge;
        }
        return hit;
    }

    public static boolean setHitCurveBearing(double wave_radius, Point2D.Double victim, Stats stats_source, double gf_null_angle, double[] bearings, boolean hit) {
        double bearing;
        double y;
        double ex = victim.getX();
        double ey = victim.getY();
        Rectangle2D.Double bot_rect = new Rectangle2D.Double(ex - 18.0 - 0.001, ey - 18.0 - 0.001, 36.002, 36.002);
        double x_delta = ex - stats_source.getX() - 18.0;
        double y_delta = ey - stats_source.getY() - 18.0;
        double x = Math.sqrt(wave_radius * wave_radius - y_delta * y_delta) * Math.signum(x_delta) + stats_source.getX();
        if (bot_rect.contains(x, y = ey - 18.0)) {
            bearing = Math.atan2(x - stats_source.getX(), y - stats_source.getY());
            DataHandling.updateMinMaxHitBearing(bearing, gf_null_angle, bearings, hit);
            hit = true;
        }
        if (bot_rect.contains(x = ex - 18.0, y = Math.sqrt(wave_radius * wave_radius - x_delta * x_delta) * Math.signum(y_delta) + stats_source.getY())) {
            bearing = Math.atan2(x - stats_source.getX(), y - stats_source.getY());
            DataHandling.updateMinMaxHitBearing(bearing, gf_null_angle, bearings, hit);
            hit = true;
        }
        x_delta = ex - stats_source.getX() + 18.0;
        y_delta = ey - stats_source.getY() + 18.0;
        x = Math.sqrt(wave_radius * wave_radius - y_delta * y_delta) * Math.signum(x_delta) + stats_source.getX();
        if (bot_rect.contains(x, y = ey + 18.0)) {
            bearing = Math.atan2(x - stats_source.getX(), y - stats_source.getY());
            DataHandling.updateMinMaxHitBearing(bearing, gf_null_angle, bearings, hit);
            hit = true;
        }
        if (bot_rect.contains(x = ex + 18.0, y = Math.sqrt(wave_radius * wave_radius - x_delta * x_delta) * Math.signum(y_delta) + stats_source.getY())) {
            bearing = Math.atan2(x - stats_source.getX(), y - stats_source.getY());
            DataHandling.updateMinMaxHitBearing(bearing, gf_null_angle, bearings, hit);
            hit = true;
        }
        return hit;
    }

    private static void updateMinMaxHitBearing(double bearing_new, double gf_null_angle, double[] gf_hit_angles, boolean hit) {
        double bearing_new_delta = Utils.normalRelativeAngle((double)(bearing_new - gf_null_angle));
        if (hit) {
            gf_hit_angles[0] = Math.min(gf_hit_angles[0], bearing_new_delta);
            gf_hit_angles[1] = Math.max(gf_hit_angles[1], bearing_new_delta);
        } else {
            gf_hit_angles[0] = gf_hit_angles[1] = bearing_new_delta;
        }
    }

    public static Point2D.Double getLineRectIntersection(Point2D.Double p0, Point2D.Double p1, Rectangle2D.Double rect) {
        Line2D.Double line_border = DataHandling.getRectIntersectingLine(p0, p1, rect);
        if (line_border == null) {
            return null;
        }
        Point2D.Double intersection = DataHandling.getLineIntersection(p0, p1, (Point2D.Double)line_border.getP1(), (Point2D.Double)line_border.getP2());
        DrawingBot.drawBigPoint(intersection, Color.WHITE);
        return intersection;
    }

    public static Line2D.Double getRectIntersectingLine(Point2D.Double p0, Point2D.Double p1, Rectangle2D.Double rect) {
        Line2D.Double line_test = new Line2D.Double(p0, p1);
        Line2D.Double line_border = new Line2D.Double(rect.x, rect.y, rect.x + rect.width, rect.y);
        if (line_test.intersectsLine(line_border)) {
            return line_border;
        }
        line_border = new Line2D.Double(rect.x, rect.y, rect.x, rect.y + rect.height);
        if (line_test.intersectsLine(line_border)) {
            return line_border;
        }
        line_border = new Line2D.Double(rect.x + rect.width, rect.y + rect.height, rect.x + rect.width, rect.y);
        if (line_test.intersectsLine(line_border)) {
            return line_border;
        }
        line_border = new Line2D.Double(rect.x + rect.width, rect.y + rect.height, rect.x, rect.y + rect.height);
        if (line_test.intersectsLine(line_border)) {
            return line_border;
        }
        System.out.println("No intersection: P1=" + line_test.x1 + ", " + line_test.y1 + " p2=" + line_test.x2 + ", " + line_test.y2);
        return null;
    }

    public static Point2D.Double getLineIntersection(Point2D.Double l0p0, Point2D.Double l0p1, Point2D.Double l1p0, Point2D.Double l1p1) {
        boolean f1 = false;
        boolean f2 = false;
        double m1 = 0.0;
        double m2 = 0.0;
        double b1 = 0.0;
        double b2 = 0.0;
        if (l0p0.x != l0p1.x) {
            m1 = (l0p0.y - l0p1.y) / (l0p0.x - l0p1.x);
            b1 = l0p0.y - l0p0.x * m1;
            f1 = true;
        }
        if (l1p0.x != l1p1.x) {
            m2 = (l1p0.y - l1p1.y) / (l1p0.x - l1p1.x);
            b2 = l1p0.y - l1p0.x * m2;
            f2 = true;
        }
        if (!f1) {
            return new Point2D.Double(l0p0.x, m2 * l0p0.x + b2);
        }
        if (!f2) {
            return new Point2D.Double(l1p0.x, m1 * l1p0.x + b1);
        }
        double x = (b1 - b2) / (m2 - m1);
        double y = m1 * x + b1;
        return new Point2D.Double(x, y);
    }

    public static boolean collidesWallAtDistance(Point2D.Double source_location, double enemy_bearing, double velocity, double distance, double wallDistance, double heading) {
        return Garm.field_rect_inner.contains(DataHandling.project(source_location, enemy_bearing + DataHandling.mySignum(velocity * Math.sin(heading - enemy_bearing)) * wallDistance, distance));
    }
}

