/*
 * Decompiled with CFR 0.152.
 */
package cf.RiO;

import cf.target;
import cf.util.Calc;
import cf.util.E_Properties;

public class RiO_GG {
    public static double getBulletTravelTime(double dist, double bulletPower) {
        return dist / (20.0 - 3.0 * bulletPower);
    }

    public static double getRealPower(double realSpeed) {
        double returnV = (20.0 - realSpeed) / 3.0;
        if (realSpeed >= 20.0) {
            return -1.0;
        }
        return returnV;
    }

    public static target getTarget(E_Properties victim, int time, double rx, double ry, double power) {
        if (victim.heading == victim.lastProp.heading) {
            return RiO_GG.getTargetLinear(victim.heading, victim.X, victim.Y, time - victim.lastScan, power, rx, ry, victim.speed);
        }
        return RiO_GG.getTargetCircular(victim.heading, time - victim.lastScan, (victim.heading - victim.lastProp.heading) / (double)(victim.lastScan - victim.lastProp.lastScan), victim.X, victim.Y, rx, ry, power, victim.speed);
    }

    public static target getTargetLinear(double heading, double startx, double starty, double timeDiff, double power, double rx, double ry, double speed) {
        double endy;
        double startDist = Calc.dist(startx, starty, rx, ry);
        if (power == -1.0) {
            power = 600.0 / startDist;
        }
        double bulletTravelTime = RiO_GG.getBulletTravelTime(startDist, power);
        double totalTime = timeDiff + bulletTravelTime;
        double moveDist = totalTime * speed;
        double endx = startx + Math.sin(Math.toRadians(heading)) * moveDist;
        double realDist = Calc.dist(rx, rx, endx, endy = starty + Math.cos(Math.toRadians(heading)) * moveDist);
        double realSpeed = realDist / bulletTravelTime;
        double realPower = RiO_GG.getRealPower(realSpeed);
        if (realPower == -1.0 && power > 0.2) {
            return RiO_GG.getTargetLinear(heading, startx, starty, timeDiff, power - 0.2, rx, ry, speed);
        }
        if (realPower == -1.0) {
            return new target(startx, starty, 400.0 / startDist, 0);
        }
        return new target(endx, endy, realPower, 0);
    }

    public static target getTargetCircular(double startHeading, double timeDiff, double turnRate, double startx, double starty, double rx, double ry, double power, double speed) {
        double startDist = Calc.dist(startx, starty, rx, ry);
        if (power == -1.0) {
            power = 600.0 / startDist;
        }
        double bulletTravelTime = RiO_GG.getBulletTravelTime(startDist, power);
        double tempx = startx;
        double tempy = starty;
        double heading = startHeading;
        int time = 0 - (int)timeDiff;
        while ((double)time < bulletTravelTime) {
            tempx += Math.sin(Math.toRadians(heading += turnRate)) * speed;
            tempx += Math.cos(Math.toRadians(heading)) * speed;
            ++time;
        }
        double realDist = Calc.dist(rx, rx, tempx, tempy);
        double realSpeed = realDist / bulletTravelTime;
        double realPower = RiO_GG.getRealPower(realSpeed);
        if (realPower == -1.0 && power > 0.2) {
            return RiO_GG.getTargetCircular(startHeading, timeDiff, turnRate, startx, starty, rx, ry, power - 0.2, speed);
        }
        if (realPower == -1.0) {
            return new target(tempx, tempy, 400.0 / startDist, 0);
        }
        return new target(tempx, tempy, realPower, 0);
    }
}

