/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode;

import robocode.AdvancedRobot;

public class Enemy {
    private String name;
    private double distance;
    private double x;
    private double y;
    private double bearing;
    private double heading;
    private double lastHeading;
    private double velocity;
    private double energy;
    private int[][] waveStats = new int[13][31];
    private AdvancedRobot robot;
    private int bucketSize = 0;
    private long lastScanTime = 0L;

    Enemy(AdvancedRobot r, String n) {
        this.robot = r;
        this.name = n;
        this.bucketSize = 360 / this.waveStats.length + 1;
    }

    void SetLocation(double d, double b, double h, double v, double e, double X, double Y, long t) {
        this.distance = d;
        this.bearing = b;
        this.lastHeading = this.heading;
        this.heading = h;
        this.velocity = v;
        this.energy = e;
        this.x = X;
        this.y = Y;
        this.lastScanTime = t;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getDistance() {
        return (int)this.distance;
    }

    String getName() {
        return this.name;
    }

    public double getBearingRadians() {
        return this.bearing;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public int[] getWaveStats() {
        double heading;
        Enemy event = this;
        int speedBucket = event.getDistance() / 100;
        for (heading = 0.7853981633974483 - this.robot.getRadarHeading() - event.getHeading(); heading < 0.0; heading += 360.0) {
        }
        while (heading > 360.0) {
            heading -= 360.0;
        }
        int headingBucket = (int)(heading / 30.0);
        int distanceBucket = event.getDistance() / 1200;
        return this.waveStats[distanceBucket];
    }

    int[] getWaveStats(Enemy event) {
        double heading;
        int speedBucket = event.getDistance() / 100;
        for (heading = 0.7853981633974483 - this.robot.getRadarHeading() - event.getHeading(); heading < 0.0; heading += 360.0) {
        }
        while (heading > 360.0) {
            heading -= 360.0;
        }
        int headingBucket = (int)(heading / 30.0);
        return this.waveStats[headingBucket];
    }

    double getEnergy() {
        return this.energy;
    }

    public double getHeadingRadians() {
        return this.heading;
    }

    public double getLastHeadingRadians() {
        return this.lastHeading;
    }

    private double getHeading() {
        return this.getHeadingRadians();
    }
}

