/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode;

import com.spp.robocode.BattlefieldModel;
import com.spp.robocode.Enemy;
import com.spp.robocode.VirtualBullet;
import com.spp.robocode.targeting.CircularTargeting;
import com.spp.robocode.targeting.GuessTargeting;
import com.spp.robocode.targeting.HeadOnTargeting;
import com.spp.robocode.targeting.LinearTargeting;
import com.spp.robocode.targeting.TargetModel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class GuidanceComputer {
    private BattlefieldModel model;
    private LinearTargeting linearTargeter;
    private GuessTargeting guessTargeter;
    private CircularTargeting circularTargeter;
    private HeadOnTargeting headonTargeter;
    private AdvancedRobot robot;
    private HashMap<String, TargetModel> targetModels;
    private ArrayList<VirtualBullet> activeBullets;
    private long lastTime;
    private HashMap<String, TargetStats> targetStats;
    int count = 0;
    private HashMap<String, String> bestModels = new HashMap();

    GuidanceComputer() {
        this.targetModels = new HashMap();
        this.targetStats = new HashMap();
        this.onNewRound();
        this.linearTargeter = new LinearTargeting();
        this.guessTargeter = new GuessTargeting();
        this.circularTargeter = new CircularTargeting();
        this.headonTargeter = new HeadOnTargeting();
        this.targetStats.put(this.linearTargeter.getName(), new TargetStats(this.linearTargeter.getName()));
        this.targetStats.put(this.circularTargeter.getName(), new TargetStats(this.circularTargeter.getName()));
        this.targetStats.put(this.guessTargeter.getName(), new TargetStats(this.guessTargeter.getName()));
        this.targetStats.put(this.headonTargeter.getName(), new TargetStats(this.headonTargeter.getName()));
        this.targetModels = new HashMap();
        this.targetModels.put(this.linearTargeter.getName(), this.linearTargeter);
        this.targetModels.put(this.guessTargeter.getName(), this.guessTargeter);
        this.targetModels.put(this.circularTargeter.getName(), this.circularTargeter);
        this.targetModels.put(this.headonTargeter.getName(), this.headonTargeter);
    }

    void onNewRound() {
        this.lastTime = 0L;
        this.activeBullets = new ArrayList();
    }

    void onScannedRobot(ScannedRobotEvent event) {
        this.guessTargeter.onScannedRobot(this.robot, event, this.model);
        this.linearTargeter.onScannedRobot(this.robot, event, this.model);
        this.circularTargeter.onScannedRobot(this.robot, event, this.model);
        this.headonTargeter.onScannedRobot(this.robot, event, this.model);
        if (this.lastTime < event.getTime()) {
            this.lastTime = event.getTime();
            this.activeBullets.forEach(b -> b.updatePosition(event.getTime()));
        }
        ListIterator<VirtualBullet> iter = this.activeBullets.listIterator();
        while (iter.hasNext()) {
            VirtualBullet b2 = iter.next();
            if (b2.getTargetname().equals(event.getName())) {
                double d = Point2D.distance(b2.getX(), b2.getY(), this.robot.getX(), this.robot.getY());
                double absBearing = this.robot.getHeadingRadians() + event.getBearingRadians();
                double ex = this.robot.getX() + Math.sin(absBearing) * event.getDistance();
                double ey = this.robot.getY() + Math.cos(absBearing) * event.getDistance();
                if (Point2D.distance(b2.getX(), b2.getY(), ex, ey) < 24.0) {
                    this.targetStats.get(b2.getTargetMethod()).onHit(event.getName());
                    iter.remove();
                    continue;
                }
                if (!(d > event.getDistance())) continue;
                this.targetStats.get(b2.getTargetMethod()).onMiss(event.getName());
                iter.remove();
                continue;
            }
            if (event.getTime() - b2.getTime() <= 100L) continue;
            this.targetStats.get(b2.getTargetMethod()).onMiss(event.getName());
            iter.remove();
        }
    }

    double getFiringSolution(Enemy enemy, double power, double robotHeading, double robotX, double robotY) {
        ++this.count;
        this.newVirtualBullet(enemy, power, robotHeading, robotX, robotY);
        this.count = 0;
        TargetModel tm = this.getBestModel(enemy.getName());
        return tm.getFiringSolution(enemy, power, this.robot, robotHeading);
    }

    double getHitRate(Enemy enemy) {
        TargetModel tm = this.getBestModel(enemy.getName());
        return this.targetStats.get(tm.getName()).hitRate(enemy.getName());
    }

    void setModel(BattlefieldModel m, AdvancedRobot r) {
        this.model = m;
        this.robot = r;
    }

    private TargetModel getBestModel(String name) {
        String oldVal = this.bestModels.get(name);
        if (oldVal == null) {
            oldVal = "none";
            this.bestModels.put(name, oldVal);
        }
        double linearScore = this.targetStats.get(this.linearTargeter.getName()).hitRate(name);
        double guessScore = this.targetStats.get(this.guessTargeter.getName()).hitRate(name);
        double circleScore = this.targetStats.get(this.circularTargeter.getName()).hitRate(name);
        double headonScore = this.targetStats.get(this.headonTargeter.getName()).hitRate(name);
        TargetModel retVal = linearScore >= guessScore && linearScore >= circleScore && linearScore >= headonScore ? this.linearTargeter : (guessScore >= linearScore && guessScore >= circleScore && guessScore >= headonScore ? this.guessTargeter : (circleScore >= linearScore && circleScore >= guessScore && circleScore >= headonScore ? this.circularTargeter : this.headonTargeter));
        System.out.println(name + " " + retVal.getName() + " " + linearScore + " " + guessScore + " " + circleScore + " " + headonScore);
        this.bestModels.put(name, retVal.getName());
        return retVal;
    }

    private void newVirtualBullet(Enemy enemy, double power, double robotHeading, double robotX, double robotY) {
        double bearing = this.linearTargeter.getFiringSolution(this.model.getEnemy(enemy.getName(), false), power, this.robot, robotHeading);
        VirtualBullet b = new VirtualBullet(enemy.getName(), this.robot.getTime(), robotX, robotY, bearing += this.robot.getGunHeadingRadians(), Rules.getBulletSpeed((double)power), this.linearTargeter.getName());
        this.activeBullets.add(b);
        bearing = this.guessTargeter.getFiringSolution(this.model.getEnemy(enemy.getName(), false), power, this.robot, robotHeading);
        b = new VirtualBullet(enemy.getName(), this.robot.getTime(), robotX, robotY, bearing += this.robot.getGunHeadingRadians(), Rules.getBulletSpeed((double)power), this.guessTargeter.getName());
        this.activeBullets.add(b);
        bearing = this.circularTargeter.getFiringSolution(this.model.getEnemy(enemy.getName(), false), power, this.robot, robotHeading);
        b = new VirtualBullet(enemy.getName(), this.robot.getTime(), robotX, robotY, bearing += this.robot.getGunHeadingRadians(), Rules.getBulletSpeed((double)power), this.circularTargeter.getName());
        this.activeBullets.add(b);
        bearing = this.headonTargeter.getFiringSolution(this.model.getEnemy(enemy.getName(), false), power, this.robot, robotHeading);
        b = new VirtualBullet(enemy.getName(), this.robot.getTime(), robotX, robotY, bearing += this.robot.getGunHeadingRadians(), Rules.getBulletSpeed((double)power), this.headonTargeter.getName());
        this.activeBullets.add(b);
    }

    public void onPaint(Graphics2D g) {
        this.activeBullets.forEach(b -> {
            if (b.getTargetMethod().equals(this.linearTargeter.getName())) {
                g.setColor(Color.green);
            } else if (b.getTargetMethod().equals(this.circularTargeter.getName())) {
                g.setColor(Color.blue);
            } else if (b.getTargetMethod().equals(this.headonTargeter.getName())) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.red);
            }
            g.fillRect((int)b.getX(), (int)b.getY(), 5, 5);
        });
    }

    private static class TargetStats {
        private String targetMethod;
        private HashMap<String, HitMiss> hitStats;

        public TargetStats(String method) {
            this.targetMethod = method;
            this.hitStats = new HashMap();
        }

        public void onHit(String target) {
            HitMiss hm = this.hitStats.get(target);
            if (hm == null) {
                hm = new HitMiss();
            }
            ++hm.hit;
        }

        public void onMiss(String target) {
            HitMiss hm = this.hitStats.get(target);
            if (hm == null) {
                hm = new HitMiss();
                this.hitStats.put(target, hm);
            }
            ++hm.miss;
        }

        public double hitRate(String target) {
            int total;
            HitMiss hm = this.hitStats.get(target);
            if (hm == null) {
                hm = new HitMiss();
                this.hitStats.put(target, hm);
            }
            if ((total = hm.hit + hm.miss) > 500) {
                hm.hit /= 10;
                hm.miss /= 10;
            }
            return (double)hm.hit / (double)(hm.hit + hm.miss);
        }

        private class HitMiss {
            int hit = 1;
            int miss = 1;

            HitMiss() {
            }
        }
    }
}

