/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Bearing;
import shrub.Heading;
import shrub.Location;
import shrub.Phasor;
import shrub.RadarInstruction;

public class Radar {
    private int mMode = 0;
    private Location mRadarLocn = new Location();
    private Heading mRadarHdng = new Heading();
    private Heading mTargetHdng = new Heading();
    private Location mTargetLocn = new Location();
    private double mScanSpeed = 0.0;
    private long mTrackDuration = 0L;
    private long mSweepDuration = 0L;
    private double mSweepQuantum = 0.0;
    private long mTime = 0L;
    private Phasor mPhasor = new Phasor();

    public void Initialise() {
        this.SetMode(0);
        this.mRadarLocn.Initialise();
        this.mRadarHdng.Initialise();
        this.mTargetHdng.Initialise();
        this.mTargetLocn.Initialise();
        this.mScanSpeed = 0.0;
        this.mTrackDuration = 0L;
        this.mSweepDuration = 0L;
        this.mSweepQuantum = 0.0;
        this.mTime = 0L;
        this.mPhasor.Initialise();
    }

    public void SetMode(int newMode) {
        this.mMode = newMode;
    }

    public void SetTime(long newTime) {
        this.mTime = newTime;
    }

    public void SetPhasor(Phasor newPhasor) {
        this.mPhasor = newPhasor;
    }

    public void SetScanSpeed(double newScanSpeed) {
        this.mScanSpeed = newScanSpeed;
    }

    public void SetTrackDuration(long newDuration) {
        this.mTrackDuration = newDuration;
    }

    public void SetSweepDuration(long newDuration) {
        this.mSweepDuration = newDuration;
    }

    public void SetSweepQuantum(double newQuantum) {
        this.mSweepQuantum = newQuantum;
    }

    public void SetRadarHdng(double newRadarHdng) {
        this.mRadarHdng.Set(newRadarHdng);
    }

    public void SetRadarLocn(double radarX, double radarY) {
        this.mRadarLocn.SetX(radarX);
        this.mRadarLocn.SetY(radarY);
    }

    public void SetRadarLocn(Location radarLocn) {
        this.mRadarLocn.Set(radarLocn);
    }

    public void SetTargetHdng(double newTargetHdng) {
        this.mTargetHdng.Set(newTargetHdng);
    }

    public void SetTargetLocn(double targetX, double targetY) {
        this.mTargetLocn.SetX(targetX);
        this.mTargetLocn.SetY(targetY);
    }

    public void SetTargetLocn(Location targetLocn) {
        this.mTargetLocn.Set(targetLocn);
    }

    public final Location GetRadarLocn() {
        return this.mRadarLocn;
    }

    public final Heading GetRadarHdng() {
        return this.mRadarHdng;
    }

    public final Phasor GetPhasor() {
        return this.mPhasor;
    }

    public RadarInstruction Process() {
        RadarInstruction instruct = new RadarInstruction();
        if (this.mMode == 0) {
            instruct.SetNothing();
        } else if (this.mMode == 1) {
            instruct.SetNothing();
        } else if (this.mMode == 2) {
            instruct.SetRotateLeft(this.mScanSpeed);
        } else if (this.mMode == 3) {
            instruct.SetRotateRight(this.mScanSpeed);
        } else if (this.mMode == 4) {
            this.ProcessTrackOnHeading(instruct, this.mTargetHdng);
        } else if (this.mMode == 5) {
            this.mTargetHdng.SetFromTo(this.mRadarLocn, this.mTargetLocn);
            this.ProcessTrackOnHeading(instruct, this.mTargetHdng);
        } else if (this.mMode == 6) {
            this.ProcessTrackWhileSweep(instruct);
        } else if (this.mMode == 7) {
            this.mTargetHdng.SetFromTo(this.mRadarLocn, this.mTargetLocn);
            this.ProcessTrackWhileSweep(instruct);
        } else if (this.mMode == 8) {
            this.ProcessPhasedAroundHeading(instruct, this.mTargetHdng);
        } else if (this.mMode == 9) {
            this.mTargetHdng.SetFromTo(this.mRadarLocn, this.mTargetLocn);
            this.ProcessPhasedAroundHeading(instruct, this.mTargetHdng);
        } else {
            System.out.println("ERROR : Radar::Process, unexpected mode");
        }
        return instruct;
    }

    public void ProcessRotateToHeading(RadarInstruction instruct, Heading rawHdng) {
        Bearing targetBearing = new Bearing();
        targetBearing.SetFromTo(this.mRadarHdng, rawHdng);
        double d = targetBearing.GetAbs();
    }

    public void ProcessTrackOnHeading(RadarInstruction instruct, Heading rawHdng) {
        Bearing targetBearing = new Bearing();
        targetBearing.SetFromTo(this.mRadarHdng, rawHdng);
        double amount = targetBearing.GetAbs() + 15.0;
        if (this.mScanSpeed < amount) {
            amount = this.mScanSpeed;
        }
        if (targetBearing.IsLeft()) {
            instruct.SetRotateLeft(amount);
        } else {
            instruct.SetRotateRight(amount);
        }
    }

    public void ProcessTrackWhileSweep(RadarInstruction instruct) {
        long overallStep = 0L;
        overallStep = this.mTime % (this.mSweepDuration * 2L + this.mTrackDuration);
        if (overallStep < this.mTrackDuration) {
            System.out.println("Time " + this.mTime + " - TRACKING");
            this.ProcessTrackOnHeading(instruct, this.mTargetHdng);
        } else {
            System.out.println("Time " + this.mTime + " - SWEEPING");
            long cycleStep = overallStep - this.mTrackDuration;
            this.ProcessSweep(instruct, cycleStep);
        }
    }

    public void ProcessSweep(RadarInstruction instruct, long cycleStep) {
        long sweepStep = 0L;
        long sense = 0L;
        double offsetPhase = 0.0;
        double offsetValue = 0.0;
        Heading offsetHdng = new Heading();
        Bearing relBearing = new Bearing();
        if (cycleStep < this.mSweepDuration) {
            sense = 1L;
            sweepStep = cycleStep;
        } else {
            sense = -1L;
            sweepStep = cycleStep - this.mSweepDuration;
        }
        offsetPhase = sense * (sweepStep - (this.mSweepDuration - 1L) / 2L);
        offsetValue = offsetPhase * this.mSweepQuantum;
        System.out.println("--- Time: " + this.mTime + ", cycle " + cycleStep + ", sweep " + sweepStep + ", offset " + offsetValue);
        offsetHdng.Set(this.mTargetHdng);
        offsetHdng.Adjust(offsetValue);
        relBearing.SetFromTo(this.mRadarHdng, offsetHdng);
        double amount = this.mScanSpeed;
        if (relBearing.GetAbs() < amount) {
            amount = relBearing.GetAbs();
        }
        if (relBearing.IsLeft()) {
            instruct.SetRotateLeft(amount);
        } else if (relBearing.IsRight()) {
            instruct.SetRotateRight(amount);
        } else {
            instruct.SetNothing();
        }
    }

    public void ProcessPhasedAroundHeading(RadarInstruction instruct, Heading rawHdng) {
        this.mPhasor.SetTimeNow(this.mTime);
        double phaseValue = this.mPhasor.GetPhaseValue();
        Heading adjHdng = new Heading();
        adjHdng.Set(rawHdng);
        adjHdng.Adjust(phaseValue);
        this.ProcessTrackOnHeading(instruct, adjHdng);
    }
}

